﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using DG.Tweening;

namespace GeneralBehaviour
{
    public class UIShowOrHideViaScaleAlpha : ShowOrHideBehavior
    {
        protected CanvasGroup myCanvasGroup;

        protected RectTransform myRectTran;
        float oriScaleValue = 1;

        protected void Awake()
        {
            myCanvasGroup = this.GetComponent<CanvasGroup>();
            if (myCanvasGroup == null)
            {
                myCanvasGroup = this.gameObject.AddComponent<CanvasGroup>();
            }

            myRectTran = this.GetComponent<RectTransform>();
            oriScaleValue = myRectTran.localScale.x;
        }

        /// <summary>
        /// 动态隐藏自身
        /// </summary>
        /// <param name="immediatly"></param>
        public  override void Hide(bool immediatly = false)
        {
            if (immediatly)
            {
                myCanvasGroup.alpha = 0;
                myCanvasGroup.interactable = false;
                myCanvasGroup.blocksRaycasts = false;

                myRectTran.localScale = new Vector3(oriScaleValue, oriScaleValue, oriScaleValue);
            }
            else
            {
                myCanvasGroup.DOFade(0, behaviorTime);
                myCanvasGroup.interactable = false;
                myCanvasGroup.blocksRaycasts = false;

                myRectTran.DOScale(0, behaviorTime);
            }

            base.Hide(immediatly);
        }

        /// <summary>
        /// 动态显示自身
        /// </summary>
        public  override void Show()
        {
            base.Show();

            myCanvasGroup.DOFade(1, behaviorTime);
            myCanvasGroup.interactable = true;
            myCanvasGroup.blocksRaycasts = true;

            myRectTran.DOScale(oriScaleValue, behaviorTime);
        }

    }

}