﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using DG.Tweening;

namespace GeneralBehaviour
{
    public class UIShowHideViaAlpha : ShowOrHideBehavior
    {
        protected  CanvasGroup myCanvasGroup;

        public void Awake()
        {
            myCanvasGroup = this.GetComponent<CanvasGroup>();

            if (myCanvasGroup == null)
            {
                myCanvasGroup = this.gameObject.AddComponent<CanvasGroup>();
            }                
        }

        public  override void Hide(bool immediatly = false)
        {
            if (immediatly)
            {
                myCanvasGroup.alpha = 0;
                myCanvasGroup.interactable = false;
                myCanvasGroup.blocksRaycasts = false;
            }
            else
            {
                myCanvasGroup.DOFade(0, behaviorTime );
                myCanvasGroup.interactable = false;
                myCanvasGroup.blocksRaycasts = false;
            }

            base.Hide(immediatly);
        }

        public  override void Show()
        {
            base.Show();

            myCanvasGroup.DOFade(1, behaviorTime );
            myCanvasGroup.interactable = true;
            myCanvasGroup.blocksRaycasts = true;
        }

    }
}