﻿using UnityEngine;
using UnityEngine.UI;
using UnityEngine.EventSystems;

namespace GeneralBehaviour
{
    public class ToggleSound : MonoBehaviour,IPointerClickHandler

    {
        Toggle  myToggle;

        public AudioClip soundAudioClip;

        public void OnPointerClick(PointerEventData eventData)
        {
            //Debug.Log("点击了");
            if (myToggle.interactable)
            {
                if (soundAudioClip != null)
                {
                    myToggle.onValueChanged.AddListener(delegate {
                        SoundManager.Instance?.PlayAudioClip(soundAudioClip);
                    });
                }
                else
                    SoundManager.Instance?.PlayInteractiveAudioClip();
            }
        }


        private void Awake()
        {
            myToggle = GetComponent<Toggle>();
        }
    }
}