﻿using UnityEngine;
using UnityEngine.UI;
using GeneralBehaviour;
using System;
using System.Collections;


public class TipsWinManager : TFStaticWindow
{

    public static TipsWinManager Instance;

    string tipsString = "";

    /// <summary>
    /// 显示的时间长度
    /// </summary>
    float showTime = 2;

    public Text tipsText;

    public Button enterBtn;


    float interval = 1;
    float preTime, intervalTime;

    /// <summary>
    /// 是否开启动态省略号模式
    /// </summary>
    bool dyEllipsis = false;

    protected override void Awake()
    {
        if (Instance != null)
            Instance = null;

        Instance = this;

        base.Awake();

        if (tipsText == null)
            tipsText = transform.Find("Content/Text").GetComponent<Text>();

        //if (enterBtn == null)
        //    enterBtn = GetComponentInChildren<Button>();
        //enterBtn.onClick.AddListener(CancelDyEllipsisTips);
    }

    // Use this for initialization
    void Start()
    {

        CloseWindow(true);
    }

    // Update is called once per frame
    void Update()
    {
        if (!isOpen)
            return;

        if (dyEllipsis)   //动态省略号模式
        {
            if (Time.time - preTime > 6 * interval)
            {
                tipsString.Trim('·');
                preTime = Time.time;
                intervalTime = Time.time;
            }
            else
            {
                if (Time.time - intervalTime > interval)
                {
                    tipsString += ('·');
                    intervalTime = Time.time;
                }
            }
        }
        else
        {
            if (showTime <= 0)
            {
                CloseWindow();
            }
            else
            {
                showTime = showTime - Time.deltaTime;
            }
        }
    }

    /// <summary>
    /// 显示提示
    /// </summary>
    public void ShowTips(string str, float duarationTime = 0)
    {
        tipsString = str;
        if (duarationTime - 0 < 0.001f)    //未指定时间，则自动根据长度计算时间
            showTime = 2 + str.Length / 10f;
        else     //指定了时间，则把时间
            showTime = duarationTime;
        tipsText.text = tipsString;

        isOpen = true;

        OpenWindow();

        //GetComponent<RectTransform>().anchoredPosition3D = Vector3.zero ;
    }

    /// <summary>
    /// 提示累加显示
    /// </summary>
    /// <param name="str"></param>
    public void AddTips(string str)
    {
        tipsString += ("\n" + str);
        showTime = 2 + str.Length / 10f;
        tipsText.text = tipsString;

        isOpen = true;

        OpenWindow();
    }


    /// <summary>
    /// 显示提示在某个位置
    /// </summary>
    public void ShowTips(string str, Vector3 pos)
    {
        tipsString = str;
        showTime = 2 + str.Length / 10f;
        tipsText.text = tipsString;

        isOpen = true;

        OpenWindow();

        GetComponent<RectTransform>().anchoredPosition3D = pos;
    }

    /// <summary>
    /// 显示动态的省略号提示，并且需要程序执行取消，一般用于无法或难以获取进度的事件的等待
    /// </summary>
    /// <param name="str"></param>
    public void ShowDyEllipsisTipsNeedCancel(string str)
    {
        tipsString = str;

        tipsText.text = tipsString;

        isOpen = true;

        OpenWindow();

        dyEllipsis = true;

        preTime = Time.time;
        intervalTime = Time.time;
    }

    /// <summary>
    /// 取消动态省略号式的等待提示
    /// </summary>
    public void CancelDyEllipsisTips()
    {
        dyEllipsis = false;
        isOpen = false;
        tipsString = "";
        CloseWindow();
    }


}
