﻿using UnityEngine;
using UnityEngine.UI;
using GeneralBehaviour;
using TMPro;

public class ProgressWin : TFStaticWindow
{
    public static ProgressWin Instance;


    public TMP_Text progressValueText;
    public Text tipsText;
    Slider slider;

    protected override void Awake()
    {
        if (Instance != null)
            Instance = null;

        Instance = this;

        base.Awake();

        if(tipsText ==null )
            tipsText = transform.Find ("TipsText").GetComponent <Text>();
        if(progressValueText ==null )
            progressValueText = transform.Find ("ProgressValueText").GetComponent<TMP_Text>();

        slider = transform.Find("ProgressSlider").GetComponent<Slider>();

        //tipsText.gameObject.SetActive(false);
        //progressValueText.gameObject.SetActive(false);
        //slider.gameObject.SetActive(false);
    }

    // Use this for initialization
    void Start()
    {
        CloseWindow(true);
    }

    public void SetTips(string tipsStr)
    {
        tipsText.text = tipsStr;
    }
    public void ShowProgress(float _progress)
    {
        if (!isOpen)
            OpenWindow(true );

        slider.SetValueWithoutNotify(_progress);
        progressValueText.text = Mathf.RoundToInt( _progress*100) +"%";

        //Debug.Log("1-_progress : " + ( 1 - _progress).ToString ());
        if (1 - _progress < 0.1f)
        {
            //Debug.Log(" CloseWindow(true );");
            CloseWindow(true);
        }
    }

}
