﻿using UnityEngine.UI;
using GeneralBehaviour;
using System;

public class MsgWinManager : TFStaticWindow {

    public static MsgWinManager Instance;

    Text tipsText;
    Button btn1, btn2, cancelBtn;

    protected override void Awake()
    {
        Instance = this;

        base.Awake();
    }

	// Use this for initialization
	void Start () {
        tipsText = transform.Find("Text").GetComponent <Text>();

        btn1 = transform.Find("Bottom/ButtonA").GetComponent<Button>();
        btn2 = transform.Find("Bottom/ButtonB").GetComponent<Button>();
        cancelBtn = transform.Find ("Bottom/CancelBtn").GetComponent<Button >();

        CloseWindow(true );
    }
	
	// Update is called once per frame
	void Update () {
		
	}

    /// <summary>
    /// 单纯显示消息提示
    /// </summary>
    /// <param name="_msgString"></param>
    public  void ShowMsg(string _msgString)
    {
        OpenWindow();
        tipsText.text = _msgString;

        btn1.gameObject.SetActive(true);
        btn2.gameObject.SetActive(false);
        cancelBtn.gameObject.SetActive(false);

        btn1.onClick.RemoveAllListeners();
        btn1.onClick.AddListener(() => {
            CloseWindow();
            });
    }

    /// <summary>
    /// 显示模态弹窗，确定后处理一个委托事件
    /// </summary>
    /// <param name="_msgString">消息</param>
    /// <param name="_btn1Str">按钮文字，如确定</param>
    /// <param name="action1">按钮对应要委托的事件</param>
    public void ShowMsg(string _msgString,string _btn1Str, Action action1)
    {
        OpenWindow();
        tipsText.text = _msgString;

        btn1.gameObject.SetActive(true);
        btn2.gameObject.SetActive(false);
        cancelBtn.gameObject.SetActive(true );

        btn1.onClick.RemoveAllListeners();
        btn1.onClick.AddListener(() => {
            action1.Invoke();
            CloseWindow();
        });

        cancelBtn.onClick.RemoveAllListeners();
        cancelBtn.onClick.AddListener(()=> {
            CloseWindow();
        });
    }

    public void ShowMsg(string _msgString,string _btn1Str,string _btn2Str, Action action1,Action action2)
    {
        OpenWindow();
        tipsText.text = _msgString;

        btn1.gameObject.SetActive(true);
        btn2.gameObject.SetActive(true);
        cancelBtn.gameObject.SetActive(true);

        btn1.GetComponentInChildren<Text>().text = _btn1Str;
        btn2 .GetComponentInChildren<Text>().text = _btn2Str ;


        btn1.onClick.RemoveAllListeners();
        btn1.onClick.AddListener(() => {
            action1.Invoke();
            CloseWindow();
        });

        btn2.onClick.RemoveAllListeners();
        btn2.onClick.AddListener(() => {
            action2.Invoke();
            CloseWindow();
        });

        cancelBtn.onClick.RemoveAllListeners();
        cancelBtn.onClick.AddListener(() => {
            CloseWindow();
        });

    }
}
