﻿using UnityEngine;
using UnityEngine.UI;
using DG.Tweening;

namespace GeneralBehaviour
{
    public class TFStaticWindow : MonoBehaviour
    {

        protected CanvasGroup myCanvasGroup;

       public Button closeBtn;

        /// <summary>
        /// 标记是否处于打开状态
        /// </summary>
        protected bool isOpen = false;

        public Button[] panelBtns;
        public CanvasGroup[] pannelsCG;

        protected virtual void Awake()
        {
            myCanvasGroup = this.GetComponent<CanvasGroup>();
            if (myCanvasGroup == null)
                myCanvasGroup = this.gameObject.AddComponent<CanvasGroup>();

            Transform tranTemp = transform.Find("TitleBar/CloseBtn");
            if (tranTemp != null && closeBtn== null )
                closeBtn = tranTemp.GetComponent<Button>();
            closeBtn?.onClick.AddListener(() =>
            {
                CloseWindow();
            });

            if (panelBtns.Length > 0 && panelBtns.Length == pannelsCG.Length)
            {
                for (int i = 0, length = panelBtns.Length; i < length; i++)
                {
                    int it = i;
                    panelBtns[it].onClick.AddListener(delegate {

                        for (int j = 0, jLength = panelBtns.Length; j < jLength; j++)
                        {
                            int jt = j;
                            if (jt == it)
                            {
                                panelBtns[jt].GetComponent<Image>().color = new Color(0.8f, 1, 1, 1);
                            }
                            else
                            {
                                panelBtns[jt].GetComponent<Image>().color = new Color(1, 1, 1, 1);
                            }
                        }


                        
                        for (int j = 0, jLength = pannelsCG.Length; j < jLength; j++)
                        {
                            int jt = j;
                            if (jt == it)
                            {
                                //pannelsCG[jt].gameObject.SetActive(true);
                                pannelsCG[jt].DOFade(1, 0.3f);
                                pannelsCG[jt].interactable = true;
                                pannelsCG[jt].blocksRaycasts = true;
                            }
                            else
                            {
                                if (pannelsCG[jt].gameObject.activeInHierarchy)
                                {
                                    pannelsCG[jt].DOFade(0, 0.3f);
                                    //.onComplete = delegate
                                    //{
                                    //    pannelsCG[jt].gameObject.SetActive(false);
                                    //};
                                    pannelsCG[jt].interactable = false;
                                    pannelsCG[jt].blocksRaycasts = false;
                                }
                            }
                        }
                    });
                }
            }

        }



        public  void CloseWindow(bool immediatly = false)
        {
            if (immediatly)
            {
                myCanvasGroup.alpha = 0;
            }
            else
            {
                myCanvasGroup.DOFade(0, 0.3f);
            }

            myCanvasGroup.interactable = false;
            myCanvasGroup.blocksRaycasts = false;
            isOpen = false;
        }


        public  virtual void OpenWindow(bool immediatly = false)
        {
            gameObject.gameObject.SetActive(true);
            if (immediatly)
            {
                myCanvasGroup.alpha = 1;
            }
            else
            {
                myCanvasGroup.DOFade(1, 0.3f);
            }

            myCanvasGroup.interactable = true;
            myCanvasGroup.blocksRaycasts = true;
            isOpen = true;
        }

        public virtual void ShowSubWin(int winNum)
        {
            if (winNum >= 0 && winNum < panelBtns.Length)
            {
                if (panelBtns[winNum].gameObject.activeInHierarchy)
                {
                    panelBtns[winNum].onClick.Invoke();
                }
            }
        }
    }
}