﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace GeneralBehaviour
{
    public class SoundManager : MonoBehaviour
    {
        public static SoundManager Instance;

        public Transform[] btnsTransRoot;


        public AudioSource interactiveAudioSource;
        /// <summary>
        /// UI交互声音
        /// </summary>
        public AudioClip interactiveAudioClip;

        public AudioClip simpleSuccessAudioClip;

        public AudioClip simpleErrorAudioClip;


        public AudioSource bgMusicAudioSource;
        /// <summary>
        /// 背景音乐
        /// </summary>
        public AudioClip bgMusic;

        private void Awake()
        {
            if (Instance)
                Instance = null;
            Instance = this;


            //批量给按钮添加组件
            for (int i = 0, length = btnsTransRoot.Length; i < length; i++)
            {
                if (btnsTransRoot[i] != null)
                {
                    Button[] btns = btnsTransRoot[i].GetComponentsInChildren<Button>();
                    foreach (Button item in btns)
                    {
                        if(item.gameObject.GetComponent<ButtonSound >() == null )
                            item.gameObject.AddComponent<ButtonSound>();
                    }

                    Toggle[] toggles = btnsTransRoot[i].GetComponentsInChildren<Toggle>();
                    foreach (Toggle item in toggles)
                    {
                        if (item.gameObject.GetComponent<ToggleSound>() == null)
                            item.gameObject.AddComponent<ToggleSound>();
                    }
                }
            }
        }



        /// <summary>
        /// 播放UI交互的声音
        /// </summary>
        public void PlayInteractiveAudioClip()
        {
            //if (SystemSetting.interSoundIsOn)
            //{
                interactiveAudioSource.clip = interactiveAudioClip;
                interactiveAudioSource.Play();
            //}
        }

        /// <summary>
        /// 播放简洁明快的成功正确的声音
        /// </summary>
        public  void PlaySimpleSuccessAudioClip()
        {
            //if (SystemSetting.tipSoundIsOn)
            //{
                interactiveAudioSource.clip = simpleSuccessAudioClip ;
                interactiveAudioSource.Play();
            //}
        }


        /// <summary>
        /// 播放简介明快的失败错误的声音
        /// </summary>
        public  void PlaySimpleErrorAudioClip()
        {
            //if (SystemSetting.tipSoundIsOn)
            //{
                interactiveAudioSource.clip = simpleErrorAudioClip;
                interactiveAudioSource.Play();
            //}
        }

        /// <summary>
        /// 播放播放扣分的音频
        /// </summary>
        public void PlayMinusScoreAudioClip()
        {
            Debug.Log("播放播放扣分的音频");
        }

        public  void PlayAudioClip(AudioClip audioClip)
        {
            if (audioClip != null)
                interactiveAudioSource.clip = audioClip;
            interactiveAudioSource.Play();
        }
    }

}