﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace GeneralBehaviour
{   
    /// <summary>
    /// 显示或隐藏的行为基类
    /// </summary>
    public abstract  class ShowOrHideBehavior:MonoBehaviour
    {
        protected bool isVisible = true;
        internal bool IsVisible { get { return isVisible; } }

        [Tooltip ("行为时间")]
        public  float behaviorTime = 0.3f;

        /// <summary>
        /// 设置行为时间
        /// </summary>
        /// <param name="f"></param>
        public void SetBehaviorTime(float f)
        {
            behaviorTime = f;
        }

        /// <summary>
        /// 切换显示状态
        /// </summary>
        internal void  SwitchShowOrHide()
        {
            if (gameObject.activeInHierarchy)
            {
                Hide();

                isVisible = false;
            }
            else
            {
                Show();

                isVisible = true;
            }
        }

        /// <summary>
        /// 隐藏自身
        /// </summary>
        /// <param name="immediatly"></param>
        public  virtual void Hide(bool immediatly = false)
        {
            if (immediatly)
                gameObject.SetActive(false);
            else
                StartCoroutine(DelayDisactive());
        }

    //显示自身
        public  virtual void Show()
        {
            gameObject.SetActive(true);
            //Debug.Log("kkkkkkkkkkkkkk");
        }

        
        /// <summary>
        /// 延迟设置失活
        /// </summary>
        /// <param name="immediatly"></param>
        /// <returns></returns>
        protected virtual IEnumerator DelayDisactive()
        {
            yield return new WaitForSeconds( behaviorTime);

            gameObject.SetActive(false);
        }

    }
}