﻿using UnityEngine;
using UnityEngine.Events;
using UnityEngine.EventSystems;
using System.Collections;


namespace GeneralBehaviour
{
    public class RepeatButton : MonoBehaviour, IPointerDownHandler, IPointerUpHandler, IPointerExitHandler
    {
        public float interval = 0.1f; //回调触发间隔时间;

        public float delay = 1.0f;//延迟时间;

        public UnityEvent onLongPress = new UnityEvent();

        private bool isPointDown = false;
        private float lastInvokeTime;

        private float m_Delay = 0f;

        // Use this for initialization
        void Start()
        {
            //m_Delay = delay;
            delay = 0.1f;
        }

        // Update is called once per frame
        void Update()
        {
            if (isPointDown)
            {
                if (Time.time - m_Delay < delay)
                {
                    return;
                }

                if (Time.time - lastInvokeTime > interval)
                {
                    //触发点击;
                    onLongPress.Invoke();
                    lastInvokeTime = Time.time;
                }
            }

        }

        public void OnPointerDown(PointerEventData eventData)
        {
            isPointDown = true;
            m_Delay = Time.time;
        }

        public void OnPointerUp(PointerEventData eventData)
        {
            isPointDown = false;
            //m_Delay = Time.time;
        }

        public void OnPointerExit(PointerEventData eventData)
        {
            isPointDown = false;
            //m_Delay = Time.time;
        }
    }

}