﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using DG.Tweening;

namespace GeneralBehaviour
{
    /// <summary>
    /// 物体上下缩放切换动作
    /// </summary>
    public class ObjUpDownScaleBehavior : ShowOrHideBehavior
    {
        Renderer[] renderers;
        float yDelta = 0.1f;

        Vector3 oriScale;

        private void Awake()
        {
            renderers = GetComponentsInChildren<Renderer>();
        }

        private void Start()
        {
            oriScale = transform.localScale;
        }

        public  override void Hide(bool immediatly = false)
        {
            if (!immediatly)   //非立即消失的，动态过程启动
            {
                //transform.DOScale(oriScale * 0.1f, behaviorTime);
                transform.DOMove(-Vector3.up * yDelta, behaviorTime);
                //for (int i = 0,length = renderers.Length ; i < length; i++)
                //{
                //    renderers[0].material.DOFade(0, behaviorTime);
                //}
            }

            base.Hide(immediatly);   //其它的直接基类处理
        }

        public  override void Show()
        {
            base.Show();

            //transform.DOScale(oriScale , behaviorTime);
            transform.DOMove(Vector3.up * yDelta, behaviorTime);
            //for (int i = 0, length = renderers.Length; i < length; i++)
            //{
            //    renderers[0].material.DOFade(1, behaviorTime);
            //}
        }

        protected override  IEnumerator DelayDisactive()
        {
            yield return new WaitForSeconds(behaviorTime);

            gameObject.SetActive(false);
        }
    }
}