﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using DG.Tweening;

namespace GeneralBehaviour
{
    /// <summary>
    /// 物体上下缩放切换动作
    /// </summary>
    public class ObjScaleBehavior : ShowOrHideBehavior
    {
        Vector3 oriScale;
        public  Vector3 hideScale = new Vector3(0.1f,0.1f,0.1f);
        

        private void Awake()
        {
            oriScale = transform.localScale;
        }

        /// <summary>
        /// 设置目标
        /// </summary>
        /// <param name="_hideScale"></param>
        internal void SetTarget(Vector3 _hideScale)
        {
            hideScale = _hideScale;
        }

        public  override void Hide(bool immediatly = false)
        {
            if (immediatly)   //非立即消失的，动态过程启动
            {
                transform.localScale = hideScale;
            }
            else
                transform.DOScale(hideScale, behaviorTime);

            base.Hide(immediatly);   //其它的直接基类处理
        }

        public  override void Show()
        {
            base.Show();

            transform.DOScale(oriScale * 0.1f, behaviorTime * 0.8f).onComplete = () => { transform.DOScale(oriScale, behaviorTime * 0.2f); };
        }

        protected override  IEnumerator DelayDisactive()
        {
            yield return new WaitForSeconds(behaviorTime);

            gameObject.SetActive(false);
        }
    }
}