﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace GeneralBehaviour
{
    public class GeneralWindow : MonoBehaviour
    {
        public ShowOrHideBehavior myShowOrHideBehaviour;
        public bool defaultIsOpening = false ;


        protected virtual void Awake()
        {
            if (myShowOrHideBehaviour == null)
                myShowOrHideBehaviour = GetComponent<ShowOrHideBehavior>();
            if (myShowOrHideBehaviour == null)
                myShowOrHideBehaviour = gameObject.AddComponent<UIShowHideViaAlpha>();

        }

        // Start is called before the first frame update
        protected virtual  void Start()
        {
            if (defaultIsOpening)
                myShowOrHideBehaviour.Show();
            else
                myShowOrHideBehaviour.Hide(true);
        }

        // Update is called once per frame
        protected virtual  void Update()
        {

        }

        /// <summary>
        /// 打开场景列表窗口
        /// </summary>
        public void OpenWindow()
        {
            myShowOrHideBehaviour.Show();

            OnOpenWindow();
        }


        protected virtual void OnOpenWindow()
        { }

        /// <summary>
        /// 关闭场景列表窗口
        /// </summary>
        public void CloseWindow()
        {
            myShowOrHideBehaviour.Hide();

            OnCloseWindow();
        }

        protected virtual void OnCloseWindow()
        { }
    }

}