﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.EventSystems;


namespace GeneralBehaviour
{
    public class CanRemoveBtn : MonoBehaviour, IPointerDownHandler, IPointerUpHandler
    {
        bool down = false;
        float downTime;

        bool isEditMode = false;

        Button removeBtn;

        public void OnPointerDown(PointerEventData eventData)
        {
            down = true;
            downTime = Time.time;
        }

        public void OnPointerUp(PointerEventData eventData)
        {
            down = false;
        }

        void Awake()
        {
            if(transform.Find("RemoveBtn")!=null )
                removeBtn = transform.Find("RemoveBtn").GetComponent<Button>();
            removeBtn.gameObject.SetActive(false);
        }



        // Update is called once per frame
        void Update()
        {
            if(down )
            {
                if (removeBtn != null)
                {
                    if (Time.time - downTime > 1.2f)
                    {
                        removeBtn.gameObject.SetActive(true);

                        removeBtn.Select();

                        GetComponent<Button>().interactable = false;

                        isEditMode = true;
                    }
                }
            }

            
        }


        /// <summary>
        /// 取消编辑模式
        /// </summary>
        public  void CancelEditMode()
        {
            if (isEditMode)
            {
                if (removeBtn != null)
                {
                    removeBtn.gameObject.SetActive(false);

                    GetComponent<Button>().interactable = true;

                    isEditMode = false;
                }
            }
        }

    }

}