﻿using UnityEngine;
using UnityEngine.UI;
using UnityEngine.EventSystems;

namespace GeneralBehaviour
{
    public class ButtonSound : MonoBehaviour,IPointerClickHandler

    {
        Button myButton;

        public AudioClip soundAudioClip;

        public void OnPointerClick(PointerEventData eventData)
        {
            //Debug.Log("点击了");
            if (myButton != null && myButton.interactable)
            {
                if (soundAudioClip != null)
                {
                    myButton.onClick.AddListener(delegate {
                        SoundManager.Instance?.PlayAudioClip(soundAudioClip);
                    });
                }
                else
                {
                    if(SoundManager .Instance != null )
                        SoundManager.Instance.PlayInteractiveAudioClip();
                }
            }
        }

        //public void OnPointerDown(PointerEventData eventData)
        //{
        //    SoundManager.Instance.PlayInteractiveAudioClip();
        //}

        private void Awake()
        {
            myButton = GetComponent<Button>();
        }
    }
}

