﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace GeneralBehaviour
{
    public class ButtonHighLighter : MonoBehaviour
    {
        Button myButton;

        Coroutine flashOnCoroutine;

        int freq = 500;    //变化一次所需的时间*1000

        // Start is called before the first frame update
        void Awake()
        {
            myButton = this.GetComponent<Button>();
        }

        /// <summary>
        /// 开始闪动
        /// </summary>
        public  void FlashOn(float duration = 5)
        {
            flashOnCoroutine = StartCoroutine(StartFlash(duration ));
        }


        IEnumerator StartFlash(float duration = 5)
        {
            yield return 0;

            float startTime = Time.time;
            UnityEngine.UI.ColorBlock colorsBlock = myButton.colors;

            while (Time.time - startTime < duration)
            {
                float ft = (Mathf.RoundToInt((Time.time - startTime) * 1000) % freq) / 500.0f;
                ft = ft * 4 + 1;
                colorsBlock.colorMultiplier = ft;
                myButton.colors = colorsBlock;

                yield return 0;
            }

            colorsBlock.colorMultiplier = 0;
            myButton.colors = colorsBlock;
        }

        public  void FlashOff()
        {
            StopCoroutine(flashOnCoroutine);
        }
    }

}