﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;
using UnityEditor.SceneManagement;
using System.IO;

public class SelectingWindow : EditorWindow   // ScriptableWizard
{
    int selectedItemNum = 0;

    internal string[] selectedItemStr;
    bool[] selectedItemStas;

    ////用于储存记录Bug人的名字
    //string bugReporterName = "";
    ////用于描述Bug信息
    //string description = "";
    ////用于储存 Bug 对象
    //GameObject buggyGameObject;

    //利用构造函数来设置窗口的名字
    SelectingWindow()
    {
        this.titleContent = new GUIContent("选择窗口");
        this.ShowModal();
    }

    //[MenuItem("Tool/Bug Reporter")]
    //static void showWindow()
    //{
    //    EditorWindow.GetWindow(typeof(SelectingWindow));
    //}

    internal  void SetSelectItems(string[] strs)
    {
        selectedItemStr = strs;
        selectedItemStas = new bool[selectedItemStr.Length];
    }

    ////显示窗体
    //[MenuItem("MyWindow/First Window")]
    //private static void ShowWindow()
    //{
    //    ScriptableWizard.DisplayWizard<SelectingWindow>("WindowExample1", "确定", "取消");
    //}

    //显示时调用
    private void OnEnable()
    {
        Debug.Log("OnEnable");
    }

    ////更新时调用
    //private void OnWizardUpdate()
    //{
    //    Debug.Log("OnWizardUpdate");

    //    //if (string.IsNullOrEmpty(msg))
    //    //{
    //    //    errorString = "请输入信息内容";//错误提示
    //    //    helpString = "";//帮助提示
    //    //}
    //    //else
    //    //{
    //    //    errorString = "";
    //    //    helpString = "请点击确认按钮";
    //    //}
    //}

    ////点击确定按钮时调用
    //private void OnWizardCreate()
    //{
    //    Debug.Log("OnWizardCreate");
    //}

    ////点击第二个按钮时调用
    //private void OnWizardOtherButton()
    //{
    //    Debug.Log("OnWizardOtherButton");
    //}

    ////当ScriptableWizard需要更新其GUI时，将调用此函数以绘制内容
    ////为GUI绘制提供自定义行为，默认行为是按垂直方向排列绘制所有公共属性字段
    ////一般不重写该方法，按照默认绘制方法即可
    //protected override bool DrawWizardGUI()
    //{
    //    return base.DrawWizardGUI();
    //}

    ////隐藏时调用
    //private void OnDisable()
    //{
    //    Debug.Log("OnDisable");
    //}

    ////销毁时调用
    //private void OnDestroy()
    //{
    //    Debug.Log("OnDestroy");
    //}


    //绘制窗口界面的函数
    private void OnGUI()
    {
        GUILayout.BeginVertical();

        //绘制标题
        GUILayout.Space(10);
        GUI.skin.label.fontSize = 24;
        GUI.skin.label.alignment = TextAnchor.MiddleCenter;
        GUILayout.Label("选择窗口");

        //绘制文本
        GUILayout.Space(10);
        EditorGUILayout.BeginToggleGroup("请选择：", true);
        for (int i = 0, length = selectedItemStr.Length; i < length; i++)
        {
            selectedItemStas[i] = EditorGUILayout.Toggle(selectedItemStr[i], selectedItemStas[i]);
            if (selectedItemStas[i])
            {
                selectedItemNum = i;
            }
        }

        for (int i = 0; i < selectedItemStas.Length; i++)
        {
            if (i == selectedItemNum)
                selectedItemStas[i] = true;
            else
                selectedItemStas[i] = false;
        }
        EditorGUILayout.EndToggleGroup();

        //bugReporterName = EditorGUILayout.TextField("Bug Name", bugReporterName);

        ////绘制当前正在编辑的场景
        //GUILayout.Space(10);
        //GUI.skin.label.fontSize = 12;
        //GUI.skin.label.alignment = TextAnchor.UpperLeft;
        //GUILayout.Label("Currently Scene:" + EditorSceneManager.GetActiveScene().name);

        ////绘制当前时间
        //GUILayout.Space(10);
        //GUILayout.Label("Time:" + System.DateTime.Now);

        ////绘制对象
        //GUILayout.Space(10);
        //buggyGameObject = (GameObject)EditorGUILayout.ObjectField(
        //    "Buggy Game Object", buggyGameObject, typeof(GameObject), true);


        ////绘制描述文本区域
        //GUILayout.Space(10);
        //GUILayout.BeginHorizontal();
        //GUILayout.Label("Describtion", GUILayout.MaxWidth(80));
        //description = EditorGUILayout.TextArea(description, GUILayout.MaxHeight(75));
        //GUILayout.EndHorizontal();

        //EditorGUILayout.Space();

        ////添加名为"Save Bug"按钮
        //if (GUILayout.Button("Save Bug"))
        //{
        //    SaveBug();
        //}

        //添加名为"Save Bug With Screenshot"按钮
        //if (GUILayout.Button("Save Bug With Screenshot"))
        //{
        //    SaveBugWithScreenshot();
        //}

        GUILayout.EndVertical();

    }

    //void SaveBug()
    //{
    //    Directory.CreateDirectory("Assets/BugReports/" + bugReporterName);
    //    var now = System.DateTime.Now.ToString("yyyy年MM月dd HH时mm分ss秒");
    //    var path = "Assets\\BugReports\\" + bugReporterName + "\\" + now + ".txt";
    //    StreamWriter sw = new StreamWriter(path);
    //    sw.WriteLine(bugReporterName);
    //    sw.WriteLine(System.DateTime.Now.ToString());
    //    sw.WriteLine(EditorSceneManager.GetActiveScene().name);
    //    sw.WriteLine(description);
    //    //刷新缓存
    //    sw.Flush();
    //    //关闭流
    //    sw.Close();
    //}

    //void SaveBugWithScreenshot()
    //{
    //    SaveBug();
    //    var now = System.DateTime.Now.ToString("yyyy年MM月dd HH时mm分ss秒");
    //    var path = "Assets/BugReports/" + bugReporterName + "/" + now + ".png";
    //    ScreenCapture.CaptureScreenshot(path);
    //}
}