﻿using UnityEditor;
using UnityEngine;
using UnityEngine.UI;
using SpacePlayer;
using System.IO;
using System.Xml;
using System;
using System.Text;
using Ionic.Zip;
using System.Collections;
using UnityEngine.Networking;
using UnityEngine.SceneManagement;
using UnityEditor.SceneManagement;
using SimpleFileBrowser;
using Wormhole;
using Wormhole.CameraInter;
using System.Text.RegularExpressions;

public class SPEditor_Wormhole : MonoBehaviour
{

    static Transform srcTran;
    static Transform wormholeParent;
    static Transform displayParent;
    static Transform dataOutParent;


    static bool GettingBaseConditionForCreatingWormhole(string compType)
    {
        SpaceSourceObj sso = FindObjectOfType<SpaceSourceObj>();
        if (srcTran == null && sso != null)
            srcTran = sso.transform;
        if (srcTran == null)
            return false;

        if (wormholeParent == null)
        {
            wormholeParent = srcTran.Find("WormholeParent");
            if (wormholeParent == null)
            {
                wormholeParent = new GameObject().transform;
                wormholeParent.SetParent(srcTran);
                wormholeParent.localPosition = Vector3.zero;
                wormholeParent.localEulerAngles = Vector3.zero;
                wormholeParent.name = "WormholeParent";
            }
        }

        return true;
    }


    static bool GettingBaseConditionForSettingAsWormhole(string compType)
    {
        SpaceSourceObj sso = FindObjectOfType<SpaceSourceObj>();
        if (srcTran == null && sso != null)
            srcTran = sso.transform;
        if (srcTran == null)
            return false;     //至少有一个CustomSceneSrc
        
        if (Selection.activeGameObject == null) return false;     //至少有一个选择物

        if (Selection.activeGameObject .GetComponent("DisplayBase") != null 
            || Selection.activeGameObject.GetComponent(compType) != null ) return false;     //所选物体必须为资源内物体

        return true;
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    #region 数据虫洞——智能硬件
    [MenuItem("SpacePlayer/数据转换驱动/【智能硬件】Arduino转Bools和Ints驱动器/新建", true, 350)]
    private static bool NewWmhArduinoToBoolsIntsValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("CommonClickableTrigger");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【智能硬件】Arduino转Bools和Ints驱动器/新建", false, 350)]
    private static void NewWmhArduinoToBoolsInts()
    {
        GameObject go = new GameObject();
        go.name = "WmhArduinoToBoolsInts";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhArduinoToBoolsInts>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhArduinoToBoolsInts");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【智能硬件】Arduino转Bools和Ints驱动器/设置所选", true, 351)]
    private static bool SetAsWmhArduinoToBoolsIntsValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhArduinoToBoolsInts");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【智能硬件】Arduino转Bools和Ints驱动器/设置所选", false, 351)]
    private static void SetAsWmhArduinoToBoolsInts()
    {
        Selection.activeGameObject.AddComponent<WmhArduinoToBoolsInts>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhArduinoToBoolsInts");
    }


    ////////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【智能硬件】串口接收数据字符串驱动器/新建", true, 352)]
    private static bool NewWmhSerialToDataStringValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("CommonClickableTrigger");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【智能硬件】串口接收数据字符串驱动器/新建", false, 352)]
    private static void NewWmhSerialToDataString()
    {
        GameObject go = new GameObject();
        go.name = "WmhSerialToDataString";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhSerialToDataString>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhSerialToDataString");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【智能硬件】串口接收数据字符串驱动器/设置所选", true, 353)]
    private static bool SetAsWmhSerialToDataStringValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhSerialToDataString");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【智能硬件】串口接收数据字符串驱动器/设置所选", false, 353)]
    private static void SetAsWmhSerialToDataString()
    {
        Selection.activeGameObject.AddComponent<WmhSerialToDataString>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhSerialToDataString");
    }
    #endregion


    ///////////////////////////////////////////////////////////////////////////////////////
    #region 数据转换驱动——音频转换
    [MenuItem("SpacePlayer/数据转换驱动/【音频】音频转小数(字符串)驱动器/新建", true, 450)]
    private static bool NewWmhAudioToFloatsStringValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhAudioToFloatsString");
    }


    [MenuItem("SpacePlayer/数据转换驱动/【音频】音频转小数(字符串)驱动器/新建", false, 450)]
    private static void NewWmhAudioToFloatsString()
    {
        GameObject go = new GameObject();
        go.name = "WmhAudioToFloatsString";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        WmhAudioToFloatsString watfs = go.AddComponent<WmhAudioToFloatsString>();

        watfs .sourceAudioSource = go.AddComponent<AudioSource>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhAudioToFloatsString");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【音频】音频转小数(字符串)驱动器/设置所选AudioSource物体", true, 451)]
    private static bool SetAsWmhAudioToFloatsStringValidateFunc()
    {
        if (GettingBaseConditionForSettingAsWormhole("WmhAudioToFloatsString"))
        {
            if (Selection.activeGameObject == null)
                return false;
            else 
                return Selection.activeGameObject.GetComponent<AudioSource>() != null;
        }
        else
        {
            //Debug.Log("GettingBaseConditionForSettingAsWormhole(WmhAudioToFloatsString) return false"); 
            return false;
        }
    }


    [MenuItem("SpacePlayer/数据转换驱动/【音频】音频转小数(字符串)驱动器/设置所选AudioSource物体", false, 451)]
    private static void SetAsWmhAudioToFloatsString()
    {
        Selection.activeGameObject.AddComponent<WmhAudioToFloatsString>().sourceAudioSource = Selection.activeGameObject.GetComponent<AudioSource>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhAudioToFloatsString");
    }





    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【音频】麦克风转多重数据驱动器/新建", true, 460)]
    private static bool NewWmhMicrophoneToMultiValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhMicrophoneToMulti");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【音频】麦克风转多重数据驱动器/新建", false, 460)]
    private static void NewWmhMicrophoneToMulti()
    {
        GameObject go = new GameObject();
        go.name = "WmhMicrophoneToMulti";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        WmhMicrophoneToMulti wmtm = go.AddComponent<WmhMicrophoneToMulti>();

        wmtm.playingAudioSource  = go.AddComponent<AudioSource>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhMicrophoneToMulti");
        Selection.activeGameObject = go;
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【音频】麦克风转多重数据驱动器/设置所选", true, 461)]
    private static bool SetAsWmhMicrophoneToMultiValidateFunc()
    {
        if (GettingBaseConditionForSettingAsWormhole("WmhMicrophoneToMulti"))
        {
            if (Selection.activeGameObject == null)
                return false;
            else
                return Selection.activeGameObject.GetComponent<AudioSource>() != null;
        }
        else
        {
            return false;
        }
        //return GettingBaseConditionForSettingAsWormhole("WmhMicrophoneToMulti");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【音频】麦克风转多重数据驱动器/设置所选", false, 461)]
    private static void SetAsWmhMicrophoneToMulti()
    {
        Selection.activeGameObject.AddComponent<WmhMicrophoneToMulti>().playingAudioSource  = Selection.activeGameObject.GetComponent<AudioSource>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhMicrophoneToMulti");
    }

#endregion



    ///////////////////////////////////////////////////////////////////////////////////////
    #region 数据转换驱动——摄像头转换
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】摄像头转Texture驱动器/新建", true, 550)]
    private static bool NewWmhCameraToTextureValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhCameraToTexture");
    }


    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】摄像头转Texture驱动器/新建", false, 550)]
    private static void NewWmhCameraToTexture()
    {
        GameObject go = new GameObject();
        go.name = "WmhCameraToTexture";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhCameraToTexture>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhCameraToTexture");
        Selection.activeGameObject = go;
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】摄像头转Texture驱动器/设置所选", true, 551)]
    private static bool SetAsWmhCameraToTextureValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhCameraToTexture");
    }


    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】摄像头转Texture驱动器/设置所选", false, 551)]
    private static void SetAsDagger()
    {
        Selection.activeGameObject.AddComponent<WmhCameraToTexture>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhCameraToTexture");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】摄像头转Texture流驱动器/新建", true, 552)]
    private static bool NewWmhCameraToTextureStreamValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhCameraToTextureStream");
    }


    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】摄像头转Texture流驱动器/新建", false, 552)]
    private static void NewWmhCameraToTextureStream()
    {
        GameObject go = new GameObject();
        go.name = "WmhCameraToTextureStream";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhCameraToTextureStream>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhCameraToTextureStream");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】摄像头转Texture流驱动器/设置所选", true, 553)]
    private static bool SetAsWmhCameraToTextureStreamValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhCameraToTextureStream");
    }


    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】摄像头转Texture流驱动器/设置所选", false, 553)]
    private static void SetAsWmhCameraToTextureStream()
    {
        Selection.activeGameObject.AddComponent<WmhCameraToTextureStream>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhCameraToTextureStream");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】人脸转平面坐标驱动器/新建", true, 560)]
    private static bool NewWmhFaceToVec2ValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhFaceToVec2");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】人脸转平面坐标驱动器/新建", false, 560)]
    private static void NewWmhFaceToVec2()
    {
        GameObject go = new GameObject();
        go.name = "WmhFaceToVec2";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhFaceToVec2>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhFaceToVec2");
        Selection.activeGameObject = go;
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】人脸转平面坐标驱动器/设置所选", true, 561)]
    private static bool SetAsWmhFaceToVec2ValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhFaceToVec2");
    }


    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】人脸转平面坐标驱动器/设置所选", false, 561)]
    private static void SetAsWmhFaceToVec2()
    {
        Selection.activeGameObject.AddComponent<WmhFaceToVec2>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhFaceToVec2");
    }




    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】ARUco码转Int驱动器/新建", true, 570)]
    private static bool NewWmhMarkerToIntValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhMarkerToInt");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】ARUco码转Int驱动器/新建", false, 570)]
    private static void NewWmhMarkerToInt()
    {
        GameObject go = new GameObject();
        go.name = "WmhMarkerToInt";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhMarkerToInt>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhMarkerToInt");
        Selection.activeGameObject = go;
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】ARUco码转Int驱动器/设置所选", true, 571)]
    private static bool SetAsWmhMarkerToIntValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhMarkerToInt");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】ARUco码转Int驱动器/设置所选", false, 571)]
    private static void SetAsWmhMarkerToInt()
    {
        Selection.activeGameObject.AddComponent<WmhMarkerToInt>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhMarkerToInt");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】ARUco码转Int和Vector2驱动器/新建", true, 572)]
    private static bool NewWmhMarkerToIntAndVec2ValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhMarkerToIntAndVec2");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】ARUco码转Int和Vector2驱动器/新建", false, 572)]
    private static void NewWmhMarkerToIntAndVec2()
    {
        GameObject go = new GameObject();
        go.name = "WmhMarkerToIntAndVec2";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhMarkerToIntAndVec2>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhMarkerToIntAndVec2");
        Selection.activeGameObject = go;
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】ARUco码转Int和Vector2驱动器/设置所选", true, 573)]
    private static bool SetAWmhMarkerToIntAndVec2ValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhMarkerToIntAndVec2");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【摄像头】ARUco码转Int和Vector2驱动器/设置所选", false, 573)]
    private static void SetAsWmhMarkerToIntAndVec2()
    {
        Selection.activeGameObject.AddComponent<WmhMarkerToIntAndVec2>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhMarkerToIntAndVec2");
    }

#endregion



    ///////////////////////////////////////////////////////////////////////////////////////
    #region  数据转换驱动——AI转化组件
    [MenuItem("SpacePlayer/数据转换驱动/【AI】麦克风音频转文字驱动器/新建", true, 650)]
    private static bool NewWmhMicrophoneToStringByAliValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhMicrophoneToStringByAli");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】麦克风音频转文字驱动器/新建", false, 650)]
    private static void NewWmhMicrophoneToStringByAli()
    {
        GameObject go = new GameObject();
        go.name = "WmhMicrophoneToStringByAli";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhMicrophoneToStringByAli>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhMicrophoneToStringByAli");
        Selection.activeGameObject = go;
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【AI】麦克风音频转文字驱动器/设置所选", true, 651)]
    private static bool SetAsWmhMicrophoneToStringByAliValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhMicrophoneToStringByAli");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】麦克风音频转文字驱动器/设置所选", false, 651)]
    private static void SetAsWmhMicrophoneToStringByAli()
    {
        Selection.activeGameObject.AddComponent<WmhMicrophoneToStringByAli>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhMicrophoneToStringByAli");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里回答文本驱动器/新建", true, 660)]
    private static bool NewWmhQStringToAStringByAliValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhQStringToAStringByAli");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里回答文本驱动器/新建", false, 660)]
    private static void NewWmhQStringToAStringByAli()
    {
        GameObject go = new GameObject();
        go.name = "WmhQStringToAStringByAli";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhQStringToAStringByAli>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhQStringToAStringByAli");
        Selection.activeGameObject = go;
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里回答文本驱动器/设置所选", true, 661)]
    private static bool SetAsWmhQStringToAStringByAliValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhQStringToAStringByAli");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里回答文本驱动器/设置所选", false, 661)]
    private static void SetAsWmhQStringToAStringByAli()
    {
        Selection.activeGameObject.AddComponent<WmhQStringToAStringByAli>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhQStringToAStringByAli");
    }




    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里流式回答文本驱动器/新建", true, 662)]
    private static bool NewWmhQStringToAStringStreamByAliValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhQStringToAStringStreamByAli");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里流式回答文本驱动器/新建", false, 662)]
    private static void NewWmhQStringToAStringStreamByAli()
    {
        GameObject go = new GameObject();
        go.name = "WmhQStringToAStringStreamByAli";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhQStringToAStringStreamByAli>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhQStringToAStringStreamByAli");
        Selection.activeGameObject = go;
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里流式回答文本驱动器/设置所选", true, 663)]
    private static bool SetAsWmhQStringToAStringStreamByAliValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhQStringToAStringStreamByAli");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里流式回答文本驱动器/设置所选", false, 663)]
    private static void SetAsWmhQStringToAStringStreamByAli()
    {
        Selection.activeGameObject.AddComponent<WmhQStringToAStringStreamByAli>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhQStringToAStringStreamByAli");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里智能体流式回答文本驱动器/新建", true, 664)]
    private static bool NewWmhQStringToAStringStreamByAliAgentValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhQStringToAStringStreamByAliAgent");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里智能体流式回答文本驱动器/新建", false, 664)]
    private static void NewWmhQStringToAStringStreamByAliAgent()
    {
        GameObject go = new GameObject();
        go.name = "WmhQStringToAStringStreamByAliAgent";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhQStringToAStringStreamByAliAgent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhQStringToAStringStreamByAliAgent");
        Selection.activeGameObject = go;
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里智能体流式回答文本驱动器/设置所选", true, 665)]
    private static bool SetAsWmhQStringToAStringStreamByAliAgentValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhQStringToAStringStreamByAliAgent");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】问题文本转阿里智能体流式回答文本驱动器/设置所选", false, 665)]
    private static void SetAsWmhQStringToAStringStreamByAliAgent()
    {
        Selection.activeGameObject.AddComponent<WmhQStringToAStringStreamByAliAgent>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhQStringToAStringStreamByAliAgent");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【AI】文本转阿里语音驱动器/新建", true, 670)]
    private static bool NewWmhStringToSoundByAliValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhStringToSoundByAli");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】文本转阿里语音驱动器/新建", false, 670)]
    private static void NewWmhStringToSoundByAli()
    {
        GameObject go = new GameObject();
        go.name = "WmhStringToSoundByAli";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        WmhStringToSoundByAli ws = go.AddComponent<WmhStringToSoundByAli>();

        ws.playingAudioSource = go.AddComponent<AudioSource>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhStringToSoundByAli");
        Selection.activeGameObject = go;
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【AI】文本转阿里语音驱动器/设置所选", true, 671)]
    private static bool SetAsWmhStringToSoundByAliValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhStringToSoundByAli");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】文本转阿里语音驱动器/设置所选", false, 671)]
    private static void SetAsWmhStringToSoundByAli()
    {
        WmhStringToSoundByAli ws = Selection.activeGameObject.AddComponent<WmhStringToSoundByAli>();
        if (Selection.activeGameObject.GetComponent<AudioSource>() != null)
            ws.playingAudioSource = Selection.activeGameObject.GetComponent<AudioSource>();
        else 
            ws.playingAudioSource = Selection.activeGameObject.AddComponent<AudioSource>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhStringToSoundByAli");
    }




    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【AI】流式文本转阿里流式语音驱动器/新建", true, 672)]
    private static bool NewWmhStringToSoundStreamByAliCosyValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhStringToSoundStreamByAliCosy");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】流式文本转阿里流式语音驱动器/新建", false, 672)]
    private static void NewWmhStringToSoundStreamByAliCosy()
    {
        GameObject go = new GameObject();
        go.name = "WmhStringToSoundStreamByAliCosy";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        WmhStringToSoundStreamByAliCosy ws = go.AddComponent<WmhStringToSoundStreamByAliCosy>();

        ws.playingAudioSource = go.AddComponent<AudioSource>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhStringToSoundStreamByAliCosy");
        Selection.activeGameObject = go;
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【AI】流式文本转阿里流式语音驱动器/设置所选", true, 673)]
    private static bool SetAsWmhStringToSoundStreamByAliCosyValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhStringToSoundStreamByAliCosy");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【AI】流式文本转阿里流式语音驱动器/设置所选", false, 673)]
    private static void SetAsWmhStringToSoundStreamByAliCosy()
    {
        WmhStringToSoundStreamByAliCosy ws = Selection.activeGameObject.AddComponent<WmhStringToSoundStreamByAliCosy>();
        if (Selection.activeGameObject.GetComponent<AudioSource>() != null)
            ws.playingAudioSource = Selection.activeGameObject.GetComponent<AudioSource>();
        else
            ws.playingAudioSource = Selection.activeGameObject.AddComponent<AudioSource>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhStringToSoundStreamByAliCosy");
    }
    #endregion



    ///////////////////////////////////////////////////////////////////////////////////////
    #region 数据转换驱动——Unity组件
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】InputField文本转函数驱动器/新建", true, 750)]
    private static bool NewWmhInputFieldToStringFunctionValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhInputFieldToStringFunction");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】InputField文本转函数驱动器/新建", false, 750)]
    private static void NewWmhInputFieldToStringFunction()
    {
        GameObject go = new GameObject();
        go.name = "WmhInputFieldToStringFunction";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhInputFieldToStringFunction>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhInputFieldToStringFunction");
        Selection.activeGameObject = go;
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】InputField文本转函数驱动器/设置所选", true, 751)]
    private static bool SetAsWmhInputFieldToStringFunctionValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhInputFieldToStringFunction");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】InputField文本转函数驱动器/设置所选", false, 751)]
    private static void SetAsWmhInputFieldToStringFunction()
    {
        Selection.activeGameObject.AddComponent<WmhInputFieldToStringFunction>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhInputFieldToStringFunction");
    }




    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】Transform属性转数字驱动器/新建", true, 752)]
    private static bool NewWmhTransformAttributeToFloatValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhTransformAttributeToFloat");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】Transform属性转数字驱动器/新建", false, 752)]
    private static void NewWmhTransformAttributeToFloat()
    {
        GameObject go = new GameObject();
        go.name = "WmhTransformAttributeToFloat";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhTransformAttributeToFloat>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhTransformAttributeToFloat");
        Selection.activeGameObject = go;
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】Transform属性转数字驱动器/设置所选", true, 753)]
    private static bool SetAsWmhTransformAttributeToFloatValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhTransformAttributeToFloat");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】Transform属性转数字驱动器/设置所选", false, 753)]
    private static void SetAsWmhTransformAttributeToFloat()
    {
        Selection.activeGameObject.AddComponent<WmhTransformAttributeToFloat>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhTransformAttributeToFloat");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】当前时间转时分秒数字驱动器/新建", true, 760)]
    private static bool NewWmhTimeNowToNumbersValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhTimeNowToNumbers");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】当前时间转时分秒数字驱动器/新建", false, 760)]
    private static void NewWmhTimeNowToNumbers()
    {
        GameObject go = new GameObject();
        go.name = "WmhTimeNowToNumbers";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhTimeNowToNumbers >();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhTimeNowToNumbers");
        Selection.activeGameObject = go;
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】当前时间转时分秒数字驱动器/设置所选", true, 761)]
    private static bool SetAsWmhTimeNowToNumbersValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhTimeNowToNumbers");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】当前时间转时分秒数字驱动器/设置所选", false, 761)]
    private static void SetAsWmhTimeNowToNumbers()
    {
        Selection.activeGameObject.AddComponent<WmhTimeNowToNumbers>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhTimeNowToNumbers");
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】给定时长转时分秒数字驱动器/新建", true, 762)]
    private static bool NewWmhTimeValueToNumbersValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhTimeValueToNumbers");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】给定时长转时分秒数字驱动器/新建", false, 762)]
    private static void NewWmhTimeValueToNumbers()
    {
        GameObject go = new GameObject();
        go.name = "WmhTimeValueToNumbers";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhTimeValueToNumbers>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhTimeValueToNumbers");
        Selection.activeGameObject = go;
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】给定时长转时分秒数字驱动器/设置所选", true, 763)]
    private static bool SetAsWmhTimeValueToNumbersValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhTimeValueToNumbers");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】给定时长转时分秒数字驱动器/设置所选", false, 763)]
    private static void SetAsWmhTimeValueToNumbers()
    {
        Selection.activeGameObject.AddComponent<WmhTimeValueToNumbers>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhTimeValueToNumbers");
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】时间累计数字驱动器/新建", true, 764)]
    private static bool NewWmhTimeToTotalTimeValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhTimeToTotalTime");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】时间累计数字驱动器/新建", false, 764)]
    private static void NewWmhTimeToTotalTime()
    {
        GameObject go = new GameObject();
        go.name = "WmhTimeToTotalTime";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhTimeToTotalTime>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhTimeToTotalTime");
        Selection.activeGameObject = go;
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】时间累计数字驱动器/设置所选", true, 765)]
    private static bool SetAsWmhTimeToTotalTimeValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhTimeToTotalTime");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】时间累计数字驱动器/设置所选", false, 765)]
    private static void SetAsWmhTimeToTotalTime()
    {
        Selection.activeGameObject.AddComponent<WmhTimeToTotalTime>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhTimeToTotalTime");
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】InputAxis输入值转换数值驱动器/新建", true, 766)]
    private static bool NewWmhInputAxisToFloatValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhInputAxisToFloat");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】InputAxis输入值转换数值驱动器/新建", false, 766)]
    private static void NewWmhInputAxisToFloat()
    {
        GameObject go = new GameObject();
        go.name = "WmhInputAxisToFloat";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhInputAxisToFloat>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhInputAxisToFloat");
        Selection.activeGameObject = go;
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】InputAxis输入值转换数值驱动器/设置所选", true, 766)]
    private static bool SetAsWmhInputAxisToFloatValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhInputAxisToFloat");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【Unity组件】InputAxis输入值转换数值驱动器/设置所选", false, 766)]
    private static void SetAsWmhInputAxisToFloat()
    {
        Selection.activeGameObject.AddComponent<WmhInputAxisToFloat>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhInputAxisToFloat");
    }



    #endregion


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值转小数数值驱动器/新建", true, 800)]
    private static bool NewWmhFloatToFloatValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhFloatToFloat");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值转小数数值驱动器/新建", false, 800)]
    private static void NewWmhFloatToFloat()
    {
        GameObject go = new GameObject();
        go.name = "WmhFloatToFloat";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhFloatToFloat>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhFloatToFloat");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值转小数数值驱动器/设置所选", true, 801)]
    private static bool SetAsWmhFloatToFloatValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhFloatToFloat");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值转小数数值驱动器/设置所选", false, 801)]
    private static void SetAsWmhFloatToFloat()
    {
        Selection.activeGameObject.AddComponent<WmhFloatToFloat>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhFloatToFloat");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数转整数驱动器/新建", true, 802)]
    private static bool NewWmhFloatToIntValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhFloatToInt");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数转整数驱动器/新建", false, 802)]
    private static void NewWmhFloatToInt()
    {
        GameObject go = new GameObject();
        go.name = "WmhFloatToInt";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhFloatToInt>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhFloatToInt");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数转整数驱动器/设置所选", true, 803)]
    private static bool SetAsWmhFloatToIntValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhFloatToInt");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数转整数驱动器/设置所选", false, 803)]
    private static void SetAsWmhFloatToInt()
    {
        Selection.activeGameObject.AddComponent<WmhFloatToInt>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhFloatToInt");
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数转小数驱动器/新建", true, 804)]
    private static bool NewWmhIntToFloatValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhIntToFloat");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数转小数驱动器/新建", false, 804)]
    private static void NewWmhIntToFloat()
    {
        GameObject go = new GameObject();
        go.name = "WmhIntToFloat";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhIntToFloat>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhIntToFloat");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数转小数驱动器/设置所选", true, 805)]
    private static bool SetAsWmhIntToFloatValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhIntToFloat");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数转小数驱动器/设置所选", false, 805)]
    private static void SetAsWmhIntToFloat()
    {
        Selection.activeGameObject.AddComponent<WmhIntToFloat>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhIntToFloat");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数转布尔值驱动器/新建", true, 802)]
    private static bool NewWmhFloatToBoolValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhFloatToBool");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数转布尔值驱动器/新建", false, 802)]
    private static void NewWmhFloatToBool()
    {
        GameObject go = new GameObject();
        go.name = "WmhFloatToBool";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhFloatToBool>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhFloatToBool");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数转布尔值驱动器/设置所选", true, 803)]
    private static bool SetAsWmhFloatToBoolValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhFloatToBool");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数转布尔值驱动器/设置所选", false, 803)]
    private static void SetAsWmhFloatToBool()
    {
        Selection.activeGameObject.AddComponent<WmhFloatToBool>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhFloatToBool");
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数转布尔值驱动器/新建", true, 804)]
    private static bool NewWmhIntToBoolValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhIntToBool");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数转布尔值驱动器/新建", false, 804)]
    private static void NewWmhIntToBool()
    {
        GameObject go = new GameObject();
        go.name = "WmhIntToBool";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhIntToBool>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhIntToBool");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数转布尔值驱动器/设置所选", true, 805)]
    private static bool SetAsWmhIntToBoolValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhIntToBool");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数转布尔值驱动器/设置所选", false, 805)]
    private static void SetAsWmhIntToBool()
    {
        Selection.activeGameObject.AddComponent<WmhIntToBool>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhIntToBool");
    }





    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数数值相加驱动器/新建", true, 806)]
    private static bool NewWmhCalPlusIntsToIntValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhCalPlusIntsToInt");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数数值相加驱动器/新建", false, 806)]
    private static void NewWmhCalPlusIntsToInt()
    {
        GameObject go = new GameObject();
        go.name = "WmhCalPlusIntsToInt";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhCalPlusIntsToInt>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhCalPlusIntsToInt");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数数值相加驱动器/设置所选", true, 807)]
    private static bool SetAsWmhCalPlusIntsToIntValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhCalPlusIntsToInt");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数数值相加驱动器/设置所选", false, 807)]
    private static void SetAsWmhCalPlusIntsToInt()
    {
        Selection.activeGameObject.AddComponent<WmhCalPlusIntsToInt>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhCalPlusIntsToInt");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数数值相乘驱动器/新建", true, 808)]
    private static bool NewWmhCalMultiIntsToIntValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhCalMultiIntsToInt");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数数值相乘驱动器/新建", false, 808)]
    private static void NewWmhCalMultiIntsToInt()
    {
        GameObject go = new GameObject();
        go.name = "WmhCalMultiIntsToInt";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhCalMultiIntsToInt>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhCalMultiIntsToInt");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数数值相乘驱动器/设置所选", true, 809)]
    private static bool SetAsWmhCalMultiIntsToIntValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhCalMultiIntsToInt");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/整数数值相乘驱动器/设置所选", false, 809)]
    private static void SetAsWmhCalMultiIntsToInt()
    {
        Selection.activeGameObject.AddComponent<WmhCalMultiIntsToInt>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhCalMultiIntsToInt");
    }




    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值相加驱动器/新建", true, 810)]
    private static bool NewWmhCalPlusFloatsToFloatValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhCalPlusFloatsToFloat");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值相加驱动器/新建", false, 810)]
    private static void NewWmhCalPlusFloatsToFloat()
    {
        GameObject go = new GameObject();
        go.name = "WmhCalPlusFloatsToFloat";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhCalPlusFloatsToFloat>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhCalPlusFloatsToFloat");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值相加驱动器/设置所选", true, 811)]
    private static bool SetAsWmhCalPlusFloatsToFloatValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhCalPlusFloatsToFloat");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值相加驱动器/设置所选", false, 811)]
    private static void SetAsWmhCalPlusFloatsToFloat()
    {
        Selection.activeGameObject.AddComponent<WmhCalPlusFloatsToFloat>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhCalPlusFloatsToFloat");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值相乘驱动器/新建", true, 812)]
    private static bool NewWmhCalMultiFloatsToFloatValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhCalMultiFloatsToFloat");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值相乘驱动器/新建", false, 812)]
    private static void NewWmhCalMultiFloatsToFloat()
    {
        GameObject go = new GameObject();
        go.name = "WmhCalMultiFloatsToFloat";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhCalMultiFloatsToFloat>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhCalMultiFloatsToFloat");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值相乘驱动器/设置所选", true, 813)]
    private static bool SetAsWmhCalMultiFloatsToFloatValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhCalMultiFloatsToFloat");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/小数数值相乘驱动器/设置所选", false, 813)]
    private static void SetAsWmhCalMultiFloatsToFloat()
    {
        Selection.activeGameObject.AddComponent<WmhCalMultiFloatsToFloat>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhCalMultiFloatsToFloat");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机小数驱动器/新建", true, 821)]
    private static bool NewWmhRandomFloatValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhRandomFloat");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机小数驱动器/新建", false, 821)]
    private static void NewWmhRandomFloat()
    {
        GameObject go = new GameObject();
        go.name = "WmhRandomFloat";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhRandomFloat>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhRandomFloat");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机小数驱动器/设置所选", true, 822)]
    private static bool SetAsWmhRandomFloatValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhRandomFloat");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机小数驱动器/设置所选", false, 822)]
    private static void SetAsWmhRandomFloat()
    {
        Selection.activeGameObject.AddComponent<WmhRandomFloat>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhRandomFloat");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机整数驱动器/新建", true, 823)]
    private static bool NewWmhRandomIntValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhRandomInt");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机整数驱动器/新建", false, 823)]
    private static void NewWmhRandomInt()
    {
        GameObject go = new GameObject();
        go.name = "WmhRandomInt";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhRandomInt>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhRandomInt");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机整数驱动器/设置所选", true, 824)]
    private static bool SetAsWmhRandomIntValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhRandomInt");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机整数驱动器/设置所选", false, 824)]
    private static void SetAsWmhRandomInt()
    {
        Selection.activeGameObject.AddComponent<WmhRandomInt>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhRandomInt");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机小数数组驱动器/新建", true, 825)]
    private static bool NewWmhRandomFloatsValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhRandomFloats");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机小数数组驱动器/新建", false, 825)]
    private static void NewWmhRandomFloats()
    {
        GameObject go = new GameObject();
        go.name = "WmhRandomFloats";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhRandomFloats>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhRandomFloats");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机小数数组驱动器/设置所选", true, 826)]
    private static bool SetAsWmhRandomFloatssValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhRandomFloatss");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机小数数组驱动器/设置所选", false, 826)]
    private static void SetAsWmhRandomFloats()
    {
        Selection.activeGameObject.AddComponent<WmhRandomFloats>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhRandomFloats");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机整数数组驱动器/新建", true, 827)]
    private static bool NewWmhRandomIntsValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhRandomInts");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机整数数组驱动器/新建", false, 827)]
    private static void NewWmhRandomInts()
    {
        GameObject go = new GameObject();
        go.name = "WmhRandomInts";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhRandomInts>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhRandomInts");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机整数数组驱动器/设置所选", true, 828)]
    private static bool SetAsWmhRandomIntsValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhRandomInts");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【数据类型】类型转换/随机整数数组驱动器/设置所选", false, 828)]
    private static void SetAsWmhRandomInts()
    {
        Selection.activeGameObject.AddComponent<WmhRandomInts>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhRandomInts");
    }




    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【XML】XML内容转XMLNode字符串驱动器/新建", true, 929)]
    private static bool NewWmhXmlContentToXmlNodeValidateFunc()
    {
        return GettingBaseConditionForCreatingWormhole("WmhXmlContentToXmlNode");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【XML】XML内容转XMLNode字符串驱动器/新建", false, 929)]
    private static void NewWmhXmlContentToXmlNode()
    {
        GameObject go = new GameObject();
        go.name = "WmhXmlContentToXmlNode";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhXmlContentToXmlNode>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhXmlContentToXmlNode");
        Selection.activeGameObject = go;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【XML】XML内容转XMLNode字符串驱动器/设置所选", true, 930)]
    private static bool SetAsWmhXmlContentToXmlNodeValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormhole("WmhXmlContentToXmlNode");
    }

    [MenuItem("SpacePlayer/数据转换驱动/【XML】XML内容转XMLNode字符串驱动器/设置所选", false, 930)]
    private static void SetAsWmhXmlContentToXmlNode()
    {
        Selection.activeGameObject.AddComponent<WmhXmlContentToXmlNode>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhXmlContentToXmlNode");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【XML】XML节点内容驱动物体命令驱动器/新建", true, 931)]
    private static bool NewWmhXmlNodeToGameObjectOrderValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("WmhXmlNodeToGameObjectOrder");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【XML】XML节点内容驱动物体命令驱动器/新建", false, 931)]
    private static void NewWmhXmlNodeToGameObjectOrder()
    {
        GameObject go = new GameObject();
        go.name = "WmhXmlNodeToGameObjectOrder";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhXmlNodeToGameObjectOrder>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhXmlNodeToGameObjectOrder");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据转换驱动/【XML】XML节点内容驱动物体命令驱动器/设置所选", true, 932)]
    private static bool SetAsWmhXmlNodeToGameObjectOrderValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("WmhXmlNodeToGameObjectOrder");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【XML】XML节点内容驱动物体命令驱动器/设置所选", false, 932)]
    private static void SetAsWmhXmlNodeToGameObjectOrder()
    {
        Selection.activeGameObject.AddComponent<WmhXmlNodeToGameObjectOrder>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhXmlNodeToGameObjectOrder");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【文件】txt文件内容字符串驱动器/新建", true, 935)]
    private static bool NewWmhTxtFileToStringValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("WmhTxtFileToString");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【文件】txt文件内容字符串驱动器/新建", false, 935)]
    private static void NewWmhTxtFileToString()
    {
        GameObject go = new GameObject();
        go.name = "WmhTxtFileToString";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhTxtFileToString>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhTxtFileToString");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据转换驱动/【文件】txt文件内容字符串驱动器/设置所选", true, 936)]
    private static bool SetAsWmhTxtFileToStringValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("WmhTxtFileToString");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【文件】txt文件内容字符串驱动器/设置所选", false, 936)]
    private static void SetAsWmhTxtFileToString()
    {
        Selection.activeGameObject.AddComponent<WmhTxtFileToString>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhTxtFileToString");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】小数值对小数事件驱动器/新建", true, 937)]
    private static bool NewWmhParamDicItemToFloatEventValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("WmhParamDicItemToFloatEvent");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】小数值对小数事件驱动器/新建", false, 937)]
    private static void NewWmhParamDicItemToFloatEvent()
    {
        GameObject go = new GameObject();
        go.name = "WmhParamDicItemToFloatEvent";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhParamDicItemToFloatEvent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhParamDicItemToFloatEvent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】小数值对小数事件驱动器/设置所选", true, 938)]
    private static bool SetAsWmhParamDicItemToFloatEventValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("WmhParamDicItemToFloatEvent");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】小数值对小数事件驱动器/设置所选", false, 938)]
    private static void SetAsWmhParamDicItemToFloatEvent()
    {
        Selection.activeGameObject.AddComponent<WmhParamDicItemToFloatEvent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhParamDicItemToFloatEvent");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】整数值对整数事件驱动器/新建", true, 939)]
    private static bool NewWmhParamDicItemToIntEventValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("WmhParamDicItemToIntEvent");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】整数值对整数事件驱动器/新建", false, 939)]
    private static void NewWmhParamDicItemToIntEvent()
    {
        GameObject go = new GameObject();
        go.name = "WmhParamDicItemToIntEvent";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhParamDicItemToIntEvent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhParamDicItemToIntEvent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】整数值对整数事件驱动器/设置所选", true, 940)]
    private static bool SetAsWmhParamDicItemToIntEventValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("WmhParamDicItemToIntEvent");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】整数值对整数事件驱动器/设置所选", false, 940)]
    private static void SetAsWmhParamDicItemToIntEvent()
    {
        Selection.activeGameObject.AddComponent<WmhParamDicItemToIntEvent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhParamDicItemToIntEvent");
    }




    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】字符串对string事件驱动器/新建", true, 941)]
    private static bool NewWmhParamDicItemToStringEventValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("WmhParamDicItemToStringEvent");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】字符串对string事件驱动器/新建", false, 941)]
    private static void NewWmhParamDicItemToStringEvent()
    {
        GameObject go = new GameObject();
        go.name = "WmhParamDicItemToStringEvent";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhParamDicItemToStringEvent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhParamDicItemToStringEvent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】字符串对string事件驱动器/设置所选", true, 942)]
    private static bool SetAsWmhParamDicItemToStringEventValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("WmhParamDicItemToStringEvent");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【参数字典】字符串对string事件驱动器/设置所选", false, 942)]
    private static void SetAsWmhParamDicItemToStringEvent()
    {
        Selection.activeGameObject.AddComponent<WmhParamDicItemToStringEvent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhParamDicItemToStringEvent");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据转换驱动/【数据字符串】数据字符串对混合数值事件驱动器/新建", true, 943)]
    private static bool NewWmhDataStringToDataEventsValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("WmhDataStringToDataEvents");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据字符串】数据字符串对混合数值事件驱动器/新建", false, 943)]
    private static void NewWmhDataStringToDataEvents()
    {
        GameObject go = new GameObject();
        go.name = "WmhDataStringToDataEvents";
        go.transform.SetParent(wormholeParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WmhDataStringToDataEvents>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WmhDataStringToDataEvents");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据字符串】数据字符串对混合数值事件驱动器/设置所选", true, 944)]
    private static bool SetAsWmhDataStringToDataEventsValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("WmhDataStringToDataEvents");
    }
    [MenuItem("SpacePlayer/数据转换驱动/【数据字符串】数据字符串对混合数值事件驱动器/设置所选", false, 944)]
    private static void SetAsWmhDataStringToDataEvents()
    {
        Selection.activeGameObject.AddComponent<WmhDataStringToDataEvents>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WmhDataStringToDataEvents");
    }





    ////////////////////////////////////以下为数据显示单元相关////////////////////////////////

    static bool GettingBaseConditionForCreatingWormholeDisp(string compType)
    {
        if (srcTran == null)
        {
            SpaceSourceObj t = FindObjectOfType<SpaceSourceObj>();
            if (t != null)
                srcTran = t.transform;
        }
        if (srcTran == null)
            return false;

        if (displayParent == null)
        {
            displayParent = srcTran.Find("DisplayParent");
            if (displayParent == null)
            {
                displayParent = new GameObject().transform;
                displayParent.SetParent(srcTran);
                displayParent.localPosition = Vector3.zero;
                displayParent.localEulerAngles = Vector3.zero;
                displayParent.name = "DisplayParent";
            }
                return false;
        }
        return true;
    }


    static bool GettingBaseConditionForSettingAsWormholeDisp(string compType)
    {
        if (srcTran == null)
        {
            SpaceSourceObj t = FindObjectOfType<SpaceSourceObj>();
            if (t != null)
                srcTran = t.transform;
        }
        if (srcTran == null)
            return false;

        if (Selection.activeGameObject == null) return false;     //至少有一个选择物

        if (Selection.activeGameObject.GetComponent(compType) != null || Selection.activeGameObject.GetComponent("Wormhole.DisplayBase")!= null  ) return false;     //所选物体必须为资源内物体

        return true;
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    #region 数据呈现驱动——是否状态
    [MenuItem("SpacePlayer/数据呈现驱动/【是否】Bool驱动Active显示组件/新建", true, 1151)]
    private static bool NewDispBoolToActiveValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispBoolToActive");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【是否】Bool驱动Active显示组件/新建", false, 1151)]
    private static void NewDispBoolToActive()
    {
        GameObject go = new GameObject();
        go.name = "DispBoolToActive";
        go.transform.SetParent(displayParent );
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispBoolToActive>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispBoolToActive");
        Selection.activeGameObject = go;
    }

    [MenuItem("SpacePlayer/数据呈现驱动/【是否】Bool驱动Active显示组件/设置所选", true, 1152)]
    private static bool SetAsDispBoolToActiveValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispBoolToActive");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【是否】Bool驱动Active显示组件/设置所选", false, 1152)]
    private static void SetAsDispBoolToActive()
    {
        Selection.activeGameObject.AddComponent<DispBoolToActive>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispBoolToActive");
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【是否】Bool驱动Event执行组件/新建", true, 1153)]
    private static bool NewDispBoolToEventValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispBoolToEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【是否】Bool驱动Event执行组件/新建", false, 1153)]
    private static void NewDispBoolToEvent()
    {
        GameObject go = new GameObject();
        go.name = "DispBoolToEvent";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispBoolToEvent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispBoolToEvent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【是否】Bool驱动Event执行组件/设置所选", true, 1154)]
    private static bool SetAsDispBoolToEventValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispBoolToEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【是否】Bool驱动Event执行组件/设置所选", false, 1154)]
    private static void SetAsDispBoolToEvent()
    {
        Selection.activeGameObject.AddComponent<DispBoolToEvent>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispBoolToEvent");
    }

#endregion


    ///////////////////////////////////////////////////////////////////////////////////////
    #region 数据呈现驱动——小数及小数组
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动色彩组显示组件/新建", true, 1250)]
    private static bool NewDispFloatsStringToColorArrayValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatsStringToColorArray");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动色彩组显示组件/新建", false, 1250)]
    private static void NewDispFloatsStringToColorArray()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatsStringToColorArray";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatsStringToColorArray>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatsStringToColorArray");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动色彩组显示组件/设置所选", true, 1251)]
    private static bool SetAsDispFloatsStringToColorArrayValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatsStringToColorArray");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动色彩组显示组件/设置所选", false, 1251)]
    private static void SetAsDispFloatsStringToColorArray()
    {
        Selection.activeGameObject.AddComponent<DispFloatsStringToColorArray>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatsStringToColorArray");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动位置组显示组件/新建", true, 1252)]
    private static bool NewDispFloatsStringToPositionArrayValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatsStringToPositionArray");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动位置组显示组件/新建", false, 1252)]
    private static void NewDispFloatsStringToPositionArray()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatsStringToPositionArray";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatsStringToPositionArray>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatsStringToPositionArray");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动位置组显示组件/设置所选", true, 1253)]
    private static bool SetAsDispFloatsStringToPositionArrayValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatsStringToPositionArray");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动位置组显示组件/设置所选", false, 1253)]
    private static void SetAsDispFloatsStringToPositionArray()
    {
        Selection.activeGameObject.AddComponent<DispFloatsStringToPositionArray>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatsStringToPositionArray");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动缩放组显示组件/新建", true, 1254)]
    private static bool NewDispFloatsStringToScaleArrayValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatsStringToScaleArray");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动缩放组显示组件/新建", false, 1254)]
    private static void NewDispFloatsStringToScaleArrayArray()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatsStringToScaleArray";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatsStringToScaleArray>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatsStringToScaleArray");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动缩放组显示组件/设置所选", true, 1255)]
    private static bool SetAsDispFloatsStringToScaleArrayValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatsStringToScaleArray");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数组】数组值驱动/【小数组】数值组驱动缩放组显示组件/设置所选", false, 1255)]
    private static void SetAsDispFloatsStringToScaleArrayArray()
    {
        Selection.activeGameObject.AddComponent<DispFloatsStringToScaleArray>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatsStringToScaleArray");
    }





    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动透明显示组件/新建", true, 1262)]
    private static bool NewDispFloatToAlphaValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToAlpha");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动透明显示组件/新建", false, 1262)]
    private static void NewDispFloatToAlpha()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToAlpha";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToAlpha>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToAlpha");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动透明显示组件/设置所选", true, 1263)]
    private static bool SetAsDispFloatToAlphaValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToAlpha");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动透明显示组件/设置所选", false, 1263)]
    private static void SetAsDispFloatToAlpha()
    {
        Selection.activeGameObject.AddComponent<DispFloatToAlpha>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToAlpha");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Animation动画定位组件/新建", true, 1262)]
    private static bool NewDispFloatToAnimationValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToAnimation");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Animation动画定位组件/新建", false, 1262)]
    private static void NewDispFloatToAnimation()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToAnimation";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToAnimation>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToAnimation");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Animation动画定位组件/设置所选", true, 1263)]
    private static bool SetAsDispFloatToAnimationValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToAnimation");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Animation动画定位组件/设置所选", false, 1263)]
    private static void SetAsDispFloatToAnimation()
    {
        Selection.activeGameObject.AddComponent<DispFloatToAnimation>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToAnimation");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Animator动画定位组件/新建", true, 1262)]
    private static bool NewDispFloatToAnimatorValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToAnimator");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Animator动画定位组件/新建", false, 1262)]
    private static void NewDispFloatToAnimator()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToAnimator";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToAnimator>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToAnimator");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Animator动画定位组件/设置所选", true, 1262)]
    private static bool SetAsDispFloatToAnimatorValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToAnimator");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Animator动画定位组件/设置所选", false, 1262)]
    private static void SetAsDispFloatToAnimator()
    {
        Selection.activeGameObject.AddComponent<DispFloatToAnimator>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToAnimator");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Timeline动画定位组件/新建", true, 1263)]
    private static bool NewDispFloatToTimelineValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToTimeline");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Timeline动画定位组件/新建", false, 1263)]
    private static void NewDispFloatToTimeline()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToTimeline";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToTimeline>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToTimeline");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Timeline动画定位组件/设置所选", true, 1263)]
    private static bool SetAsDispFloatToTimelineValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToTimeline");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动Timeline动画定位组件/设置所选", false, 1263)]
    private static void SetAsDispFloatToTimeline()
    {
        Selection.activeGameObject.AddComponent<DispFloatToTimeline>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToTimeline");
    }





    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动颜色显示组件/新建", true, 1264)]
    private static bool NewDispFloatToColorValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToColor");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动颜色显示组件/新建", false, 1264)]
    private static void NewDispFloatToColor()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToColor";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToColor>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToColor");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动颜色显示组件/设置所选", true, 1265)]
    private static bool SetAsDispFloatToColorValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToColor");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动颜色显示组件/设置所选", false, 1265)]
    private static void SetAsDispFloatToColor()
    {
        Selection.activeGameObject.AddComponent<DispFloatToColor>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToColor");
    }




    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动颜色明度显示组件/新建", true, 1266)]
    private static bool NewDispFloatToColorBrightnessValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToColorBrightness");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动颜色明度显示组件/新建", false, 1266)]
    private static void NewDispFloatToColorBrightness()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToColorBrightness";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToColorBrightness>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToColorBrightness");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动颜色明度显示组件/设置所选", true, 1267)]
    private static bool SetAsDispFloatToColorBrightnessValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToColorBrightness");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动颜色明度显示组件/设置所选", false, 1267)]
    private static void SetAsDispFloatToColorBrightness()
    {
        Selection.activeGameObject.AddComponent<DispFloatToColorBrightness>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToColorBrightness");
    }




    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动光亮显示组件/新建", true, 1268)]
    private static bool NewDispFloatToLightIntensityValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToLightIntensity");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动光亮显示组件/新建", false, 1268)]
    private static void NewDispFloatToLightIntensity()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToLightIntensity";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToLightIntensity>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToLightIntensity");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动光亮显示组件/设置所选", true, 1269)]
    private static bool SetAsDispFloatToLightIntensityValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToLightIntensity");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动光亮显示组件/设置所选", false, 1269)]
    private static void SetAsDispFloatToLightIntensity()
    {
        Selection.activeGameObject.AddComponent<DispFloatToLightIntensity>();

        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToLightIntensity");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动角度显示组件/新建", true, 1270)]
    private static bool NewDispFloatToLocalEulerAnglesValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToLocalEulerAngles");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动角度显示组件/新建", false, 1270)]
    private static void NewDispFloatToLocalEulerAngles()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToLocalEulerAngles";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToLocalEulerAngles>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToLocalEulerAngles");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动角度显示组件/设置所选", true, 1271)]
    private static bool SetAsDispFloatToLocalEulerAnglesValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToLocalEulerAngles");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动角度显示组件/设置所选", false, 1271)]
    private static void SetAsDispFloatToLocalEulerAngles()
    {
        Selection.activeGameObject.AddComponent<DispFloatToLocalEulerAngles>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToLocalEulerAngles");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动位置显示组件/新建", true, 1272)]
    private static bool NewDispFloatToLocalPositionValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToLocalPosition");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动位置显示组件/新建", false, 1272)]
    private static void NewDispFloatToLocalPosition()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToLocalPosition";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToLocalPosition>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToLocalPosition");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动位置显示组件/设置所选", true, 1273)]
    private static bool SetAsDispFloatToLocalPositionValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToLocalPosition");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动位置显示组件/设置所选", false, 1273)]
    private static void SetAsDispFloatToLocalPosition()
    {
        Selection.activeGameObject.AddComponent<DispFloatToLocalPosition>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToLocalPosition");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动缩放显示组件/新建", true, 1274)]
    private static bool NewDispFloatToLocalScaleValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToLocalScale");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动缩放显示组件/新建", false, 1274)]
    private static void NewDispFloatToLocalScale()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToLocalScale";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToLocalScale>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToLocalScale");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动缩放显示组件/设置所选", true, 1275)]
    private static bool SetAsDispFloatToLocalScaleValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToLocalScale");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动缩放显示组件/设置所选", false, 1275)]
    private static void SetAsDispFloatToLocalScale()
    {
        Selection.activeGameObject.AddComponent<DispFloatToLocalScale>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToLocalScale");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动分段事件执行组件/新建", true, 1276)]
    private static bool NewDispFloatToSegEventValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToSegEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动分段事件执行组件/新建", false, 1276)]
    private static void NewDispFloatToSegEvent()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToSegEvent";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToSegEvent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToSegEvent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动分段事件执行组件/设置所选", true, 1277)]
    private static bool SetAsDispFloatToSegEventValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToSegEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动分段事件执行组件/设置所选", false, 1277)]
    private static void SetAsDispFloatToSegEvent()
    {
        Selection.activeGameObject.AddComponent<DispFloatToSegEvent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToSegEvent");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动刚体加力执行组件/新建", true, 1278)]
    private static bool NewDispFloatToForceValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToForce");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动刚体加力执行组件/新建", false, 1278)]
    private static void NewDispFloatToForce()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToForce";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToForce>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToForce");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动刚体加力执行组件/设置所选", true, 1279)]
    private static bool SetAsDispFloatToForceValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToForce");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动刚体加力执行组件/设置所选", false, 1279)]
    private static void SetAsDispFloatToForce()
    {
        Selection.activeGameObject.AddComponent<DispFloatToForce>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToForce");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动刚体加力矩执行组件/新建", true, 1280)]
    private static bool NewDispFloatToTorqueValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToTorque");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动刚体加力矩执行组件/新建", false, 1280)]
    private static void NewDispFloatToTorque()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToTorque";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToTorque>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToTorque");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动刚体加力矩执行组件/设置所选", true, 1281)]
    private static bool SetAsDispFloatToTorqueValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToTorque");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动刚体加力矩执行组件/设置所选", false, 1281)]
    private static void SetAsDispFloatToTorque()
    {
        Selection.activeGameObject.AddComponent<DispFloatToTorque>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToTorque");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动延时事件执行组件/新建", true, 1282)]
    private static bool NewDispFloatToDelayEventValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispFloatToDelayEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动延时事件执行组件/新建", false, 1282)]
    private static void NewDispFloatToDelayEvent()
    {
        GameObject go = new GameObject();
        go.name = "DispFloatToDelayEvent";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispFloatToDelayEvent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispFloatToDelayEvent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动延时事件执行组件/设置所选", true, 1283)]
    private static bool SetAsDispFloatToDelayEventValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispFloatToDelayEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【小数】数值驱动/【小数】数值驱动延时事件执行组件/设置所选", false, 1283)]
    private static void SetAsDispFloatToDelayEvent()
    {
        Selection.activeGameObject.AddComponent<DispFloatToDelayEvent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispFloatToDelayEvent");
    }

    #endregion


    //////////////////////////////////////整数///////////////////////////////////////////
    #region 整数类型驱动显示区段

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动键值事件执行组件/新建", true, 1350)]
    private static bool NewDispIntToDicIntEventValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispIntToDicIntEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动键值事件执行组件/新建", false, 1350)]
    private static void NewDispIntToDicIntEvent()
    {
        GameObject go = new GameObject();
        go.name = "DispIntToDicIntEvent";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispIntToDicIntEvent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispIntToDicIntEvent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动键值事件执行组件/设置所选", true, 1352)]
    private static bool SetAsDispIntToDicIntEventValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispIntToDicIntEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动键值事件执行组件/设置所选", false, 1352)]
    private static void SetAsDispIntToDicIntEvent()
    {
        Selection.activeGameObject.AddComponent<DispIntToDicIntEvent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispIntToDicIntEvent");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动正误事件执行组件/新建", true, 1353)]
    private static bool NewDispIntToRightWrongEventValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispIntToRightWrongEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动正误事件执行组件/新建", false, 1353)]
    private static void NewDispIntToRightWrongEvent()
    {
        GameObject go = new GameObject();
        go.name = "DispIntToRightWrongEvent";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispIntToRightWrongEvent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispIntToRightWrongEvent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动正误事件执行组件/设置所选", true, 1354)]
    private static bool SetAsDispIntToRightWrongEventValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispIntToRightWrongEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动正误事件执行组件/设置所选", false, 1354)]
    private static void SetAsDispIntToRightWrongEvent()
    {
        Selection.activeGameObject.AddComponent<DispIntToRightWrongEvent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispIntToRightWrongEvent");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动生成对应数量物体执行组件/新建", true, 1355)]
    private static bool NewDispIntToPrefabCountSpawnValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispIntToPrefabCountSpawn");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动生成对应数量物体执行组件/新建", false, 1355)]
    private static void NewDispIntToPrefabCountSpawn()
    {
        GameObject go = new GameObject();
        go.name = "DispIntToPrefabCountSpawn";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispIntToPrefabCountSpawn>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispIntToPrefabCountSpawn");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动生成对应数量物体执行组件/设置所选", true, 1356)]
    private static bool SetAsDispIntToPrefabCountSpawnValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispIntToPrefabCountSpawn");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动生成对应数量物体执行组件/设置所选", false, 1356)]
    private static void SetAsDispIntToPrefabCountSpawn()
    {
        Selection.activeGameObject.AddComponent<DispIntToPrefabCountSpawn>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispIntToPrefabCountSpawn");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动生成指定编号的物体执行组件/新建", true, 1357)]
    private static bool NewDispIntToPrefabNumSpawnValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispIntToPrefabNumSpawn");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动生成指定编号的物体执行组件/新建", false, 1357)]
    private static void NewDispIntToPrefabNumSpawn()
    {
        GameObject go = new GameObject();
        go.name = "DispIntToPrefabNumSpawn";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispIntToPrefabNumSpawn>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispIntToPrefabNumSpawn");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动生成指定编号的物体执行组件/设置所选", true, 1358)]
    private static bool SetAsDispIntToPrefabNumSpawnValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispIntToPrefabNumSpawn");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【整数】数值驱动/【整数】数值驱动生成指定编号的物体执行组件/设置所选", false, 1358)]
    private static void SetAsDispIntToPrefabNumSpawn()
    {
        Selection.activeGameObject.AddComponent<DispIntToPrefabNumSpawn>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispIntToPrefabNumSpawn");
    }
    #endregion


    ////////////////////////////////Json字符串数值驱动/////////////////////////////////////
    #region Json字符串数值驱动
    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】二维坐标驱动位置显示组件/新建", true, 1451)]
    private static bool NewDispJsonVec2ToLocalPosValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispJsonVec2ToLocalPos");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】二维坐标驱动位置显示组件/新建", false, 1451)]
    private static void NewDispJsonVec2ToLocalPos()
    {
        GameObject go = new GameObject();
        go.name = "DispJsonVec2ToLocalPos";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispJsonVec2ToLocalPos>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispJsonVec2ToLocalPos");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】二维坐标驱动位置显示组件/设置所选", true, 1452)]
    private static bool SetAsDispJsonVec2ToLocalPosValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispJsonVec2ToLocalPos");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】二维坐标驱动位置显示组件/设置所选", false, 1452)]
    private static void SetAsDispJsonVec2ToLocalPos()
    {
        Selection.activeGameObject.AddComponent<DispJsonVec2ToLocalPos>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispJsonVec2ToLocalPos");
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动位置显示组件/新建", true, 1453)]
    private static bool NewDispJsonVec3ToLocalPosValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispJsonVec3ToLocalPos");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动位置显示组件/新建", false, 1453)]
    private static void NewDispJsonVec3ToLocalPos()
    {
        GameObject go = new GameObject();
        go.name = "DispJsonVec3ToLocalPos";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispJsonVec3ToLocalPos>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispJsonVec3ToLocalPos");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动位置显示组件/设置所选", true, 1454)]
    private static bool SetAsDispJsonVec3ToLocalPosValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispJsonVec3ToLocalPos");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动位置显示组件/设置所选", false, 1454)]
    private static void SetAsDispJsonVec3ToLocalPos()
    {
        Selection.activeGameObject.AddComponent<DispJsonVec3ToLocalPos>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispJsonVec3ToLocalPos");
    }

    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动角度显示组件/新建", true, 1455)]
    private static bool NewDispJsonVec3ToLocalEulerAnglesValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispJsonVec3ToLocalEulerAngles");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动角度显示组件/新建", false, 1455)]
    private static void NewDispJsonVec3ToLocalEulerAngles()
    {
        GameObject go = new GameObject();
        go.name = "DispJsonVec3ToLocalEulerAngles";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispJsonVec3ToLocalEulerAngles>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispJsonVec3ToLocalEulerAngles");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动角度显示组件/设置所选", true, 1456)]
    private static bool SetAsDispJsonVec3ToLocalEulerAnglesValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispJsonVec3ToLocalEulerAngles");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动角度显示组件/设置所选", false, 1456)]
    private static void SetAsDispJsonVec3ToLocalEulerAngles()
    {
        Selection.activeGameObject.AddComponent<DispJsonVec3ToLocalEulerAngles>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispJsonVec3ToLocalEulerAngles");
    }


    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动缩放显示组件/新建", true, 1457)]
    private static bool NewDispJsonVec3ToScale3ValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispJsonVec3ToScale3");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动缩放显示组件/新建", false, 1457)]
    private static void NewDispJsonVec3ToScale3()
    {
        GameObject go = new GameObject();
        go.name = "DispJsonVec3ToScale3";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispJsonVec3ToScale3>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispJsonVec3ToScale3");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动缩放显示组件/设置所选", true, 1458)]
    private static bool SetAsDispJsonVec3ToScale3ValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispJsonVec3ToScale3");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Json文本】三维坐标驱动缩放显示组件/设置所选", false, 1458)]
    private static void SetAsDispJsonVec3ToScale3()
    {
        Selection.activeGameObject.AddComponent<DispJsonVec3ToScale3>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispJsonVec3ToScale3");
    }

    #endregion Json字符串数值驱动




    ////////////////////////////////XML节点字符串数值驱动/////////////////////////////////////
    #region XML节点字符串数值驱动
    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【XML】XML模板节点列表在静态映射显示组件/新建", true, 1461)]
    private static bool NewDispXmlTemplateItemToStaticComponentsValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispXmlTemplateItemToStaticComponents");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【XML】XML模板节点列表在静态映射显示组件/新建", false, 1461)]
    private static void NewDispXmlTemplateItemToStaticComponents()
    {
        GameObject go = new GameObject();
        go.name = "DispXmlTemplateItemToStaticComponents";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispXmlTemplateItemToStaticComponents>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispXmlTemplateItemToStaticComponents");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【XML】XML模板节点列表静态映射显示组件/设置所选", true, 1462)]
    private static bool SetAsDispXmlTemplateItemToStaticComponentsValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispXmlTemplateItemToStaticComponents");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【XML】XML模板节点列表在静态映射显示组件/设置所选", false, 1462)]
    private static void SetAsDispXmlTemplateItemToStaticComponents()
    {
        Selection.activeGameObject.AddComponent<DispXmlTemplateItemToStaticComponents>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispXmlTemplateItemToStaticComponents");
    }



    ///////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【XML】XML标准节点列表动态生成显示组件/新建", true, 1463)]
    private static bool NewDispXmlTemplateItemToDynamicComponentsValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispXmlTemplateItemToDynamicComponents");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【XML】XML标准节点列表动态生成显示组件/新建", false, 1463)]
    private static void NewDispXmlTemplateItemToDynamicComponents()
    {
        GameObject go = new GameObject();
        go.name = "DispXmlTemplateItemToDynamicComponents";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispXmlTemplateItemToDynamicComponents>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispXmlTemplateItemToDynamicComponents");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【XML】XML标准节点列表动态生成显示组件/设置所选", true, 1464)]
    private static bool SetAsDispXmlTemplateItemToDynamicComponentsValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispXmlTemplateItemToDynamicComponents");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【XML】XML标准节点列表动态生成显示组件/设置所选", false, 1464)]
    private static void SetAsDispXmlTemplateItemToDynamicComponents()
    {
        Selection.activeGameObject.AddComponent<DispXmlTemplateItemToDynamicComponents>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispXmlTemplateItemToDynamicComponents");
    }


    #endregion XML节点字符串数值驱动


    ///////////////////////////////////////////////////////////////////////////////////////
    #region 泛字符串相关（物体进入、参数字典、文本显示、字符串字典事件

    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform前往目标位姿执行组件/新建", true, 1551)]
    private static bool NewDispTransformToTargetValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispTransformToTarget");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform前往目标位姿执行组件/新建", false, 1551)]
    private static void NewDispTransformToTarget()
    {
        GameObject go = new GameObject();
        go.name = "DispTransformToTarget";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispTransformToTarget>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispTransformToTarget");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform前往目标位姿执行组件/设置所选", true, 1552)]
    private static bool SetAsDispTransformToTargetValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispTransformToTarget");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform前往目标位姿执行组件/设置所选", false, 1552)]
    private static void SetAsDispTransformToTarget()
    {
        Selection.activeGameObject.AddComponent<DispTransformToTarget>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispTransformToTarget");
    }


    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform序列按行列排布呈现组件/新建", true, 1551)]
    private static bool NewDispTransformsToRowRankValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispTransformsToRowRank");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform序列按行列排布呈现组件/新建", false, 1551)]
    private static void NewDispTransformsToRowRank()
    {
        GameObject go = new GameObject();
        go.name = "DispTransformsToRowRank";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispTransformsToRowRank>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispTransformsToRowRank");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform序列按行列排布呈现组件/设置所选", true, 1552)]
    private static bool SetAsDispTransformsToRowRankValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispTransformsToRowRank");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform序列按行列排布呈现组件/设置所选", false, 1552)]
    private static void SetAsDispTransformsToRowRank()
    {
        Selection.activeGameObject.AddComponent<DispTransformsToRowRank>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispTransformsToRowRank");
    }

    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform组合整体显示或隐藏显示组件/新建", true, 1551)]
    private static bool NewDispTransformsToShowHideValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispTransformsToShowHide");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform组合整体显示或隐藏显示组件/新建", false, 1551)]
    private static void NewDispTransformsToShowHide()
    {
        GameObject go = new GameObject();
        go.name = "DispTransformsToShowHide";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispTransformsToShowHide>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispTransformsToShowHide");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform组合整体显示或隐藏显示组件/设置所选", true, 1551)]
    private static bool SetAsDispTransformsToShowHideValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispTransformsToShowHide");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform组合整体显示或隐藏显示组件/设置所选", false, 1551)]
    private static void SetAsDispTransformsToShowHide()
    {
        Selection.activeGameObject.AddComponent<DispTransformsToShowHide>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispTransformsToShowHide");
    }



    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform跟踪目标执行组件/新建", true, 1552)]
    private static bool NewDispTransformToFollowValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispTransformToFollow");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform跟踪目标执行组件/新建", false, 1552)]
    private static void NewDispTransformToFollow()
    {
        GameObject go = new GameObject();
        go.name = "DispTransformToFollow";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispTransformToFollow>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispTransformToFollow");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform跟踪目标执行组件/设置所选", true, 1552)]
    private static bool SetAsDispTransformToFollowValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispTransformToFollow");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Transform】Transform跟踪目标执行组件/设置所选", false, 1552)]
    private static void SetAsDispTransformToFollow()
    {
        Selection.activeGameObject.AddComponent<DispTransformToFollow>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispTransformToFollow");
    }




    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【刚体】刚体进入范围驱动事件执行组件/新建", true, 1553)]
    private static bool NewDispObjEnterToEventValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispObjEnterToEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【刚体】刚体进入范围驱动事件执行组件/新建", false, 1553)]
    private static void NewDispObjEnterToEvent()
    {
        GameObject go = new GameObject();
        go.name = "DispObjEnterToEvent";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispObjEnterToEvent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispObjEnterToEvent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【刚体】刚体进入范围驱动事件执行组件/设置所选", true, 1554)]
    private static bool SetAsDispObjEnterToEventValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispObjEnterToEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【刚体】刚体进入范围驱动事件执行组件/设置所选", false, 1554)]
    private static void SetAsDispObjEnterToEvent()
    {
        Selection.activeGameObject.AddComponent<DispObjEnterToEvent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispObjEnterToEvent");
    }


    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【刚体】刚体碰撞驱动事件执行组件/新建", true, 1553)]
    private static bool NewDispObjCollisionToEventValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispObjCollisionToEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【刚体】刚体碰撞驱动事件执行组件/新建", false, 1553)]
    private static void NewDispObjCollisionToEvent()
    {
        GameObject go = new GameObject();
        go.name = "DispObjCollisionToEvent";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispObjCollisionToEvent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispObjCollisionToEvent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【刚体】刚体碰撞驱动事件执行组件/设置所选", true, 1554)]
    private static bool SetAsDispObjCollisionToEventValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispObjCollisionToEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【刚体】刚体碰撞驱动事件执行组件/设置所选", false, 1554)]
    private static void SetAsDispObjCollisionToEvent()
    {
        Selection.activeGameObject.AddComponent<DispObjCollisionToEvent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispObjCollisionToEvent");
    }



    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【参数字典】字典键驱动结果显示组件/新建", true, 1555)]
    private static bool NewDispParamDicItemToTextComponentValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispParamDicItemToTextComponent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【参数字典】字典键驱动结果显示组件/新建", false, 1555)]
    private static void NewDispParamDicItemToTextComponent()
    {
        GameObject go = new GameObject();
        go.name = "DispParamDicItemToTextComponent";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispParamDicItemToTextComponent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispParamDicItemToTextComponent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【参数字典】字典键驱动结果显示组件/设置所选", true, 1556)]
    private static bool SetAsDispParamDicItemToTextComponentValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispParamDicItemToTextComponent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【参数字典】字典键驱动结果显示组件/设置所选", false, 1556)]
    private static void SetAsDispParamDicItemToTextComponent()
    {
        Selection.activeGameObject.AddComponent<DispParamDicItemToTextComponent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispParamDicItemToTextComponent");
    }


    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【常规变量】指定变量驱动显示组件/新建", true, 1557)]
    private static bool NewDispStringIntFloatToTextComponentValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispStringIntFloatToTextComponent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【常规变量】指定变量驱动显示组件/新建", false, 1557)]
    private static void NewDispStringIntFloatToTextComponent()
    {
        GameObject go = new GameObject();
        go.name = "DispStringIntFloatToTextComponent";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispStringIntFloatToTextComponent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispStringIntFloatToTextComponent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【常规变量】指定变量驱动显示组件/设置所选", true, 1558)]
    private static bool SetAsDispStringIntFloatToTextComponentValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispStringIntFloatToTextComponent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【常规变量】指定变量驱动显示组件/设置所选", false, 1558)]
    private static void SetAsDispStringIntFloatToTextComponent()
    {
        Selection.activeGameObject.AddComponent<DispStringIntFloatToTextComponent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispStringIntFloatToTextComponent");
    }



    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【字符串指令】字符串驱动字典事件执行组件/新建", true, 1559)]
    private static bool NewDispStringToDicStringEventValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispStringToDicStringEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【字符串指令】字符串驱动字典事件执行组件/新建", false, 1559)]
    private static void NewDispStringToDicStringEvent()
    {
        GameObject go = new GameObject();
        go.name = "DispStringToDicStringEvent";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispStringToDicStringEvent>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispStringToDicStringEvent");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【字符串指令】字符串驱动字典事件执行组件/设置所选", true, 1560)]
    private static bool SetAsDispStringToDicStringEventValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispStringToDicStringEvent");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【字符串指令】字符串驱动字典事件执行组件/设置所选", false, 1560)]
    private static void SetAsDispStringToDicStringEvent()
    {
        Selection.activeGameObject.AddComponent<DispStringToDicStringEvent>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispStringToDicStringEvent");
    }






    #endregion


    ////////////////////////////////////其它类型驱动显示组件
    #region 其它类型驱动显示组件
    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动Renderer显示组件/新建", true, 1653)]
    private static bool NewDispTextureToRendererValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispTextureToRenderer");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动Renderer显示组件/新建", false, 1653)]
    private static void NewDispTextureToRenderer()
    {
        GameObject go = new GameObject();
        go.name = "DispTextureToRenderer";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispTextureToRenderer>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispTextureToRenderer");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动Renderer显示组件/设置所选", true, 1654)]
    private static bool SetAsDispTextureToRendererValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispTextureToRenderer");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动Renderer显示组件/设置所选", false, 1654)]
    private static void SetAsDispTextureToRenderer()
    {
        Selection.activeGameObject.AddComponent<DispTextureToRenderer>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispTextureToRenderer");
    }


    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动UIImage显示组件/新建", true, 1653)]
    private static bool NewDispTextureToUIImageValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispTextureToUIImage");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动UIImage显示组件/新建", false, 1653)]
    private static void NewDispTextureToUIImage()
    {
        GameObject go = new GameObject();
        go.name = "DispTextureToUIImage";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispTextureToUIImage>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispTextureToUIImage");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动UIImage显示组件/设置所选", true, 1654)]
    private static bool SetAsDispTextureToUIImageValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispTextureToUIImage");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动UIImage显示组件/设置所选", false, 1654)]
    private static void SetAsDispTextureToUIImage()
    {
        Selection.activeGameObject.AddComponent<DispTextureToUIImage>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispTextureToUIImage");
    }


    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动UIRawImage显示组件/新建", true, 1653)]
    private static bool NewDispTextureToUIRawImageValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispTextureToUIRawImage");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动UIRawImage显示组件/新建", false, 1653)]
    private static void NewDispTextureToUIRawImage()
    {
        GameObject go = new GameObject();
        go.name = "DispTextureToUIRawImage";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispTextureToUIRawImage>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispTextureToUIRawImage");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动UIRawImage显示组件/设置所选", true, 1654)]
    private static bool SetAsDispTextureToUIRawImageValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispTextureToUIRawImage");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【Texture】图片驱动UIRawImage显示组件/设置所选", false, 1654)]
    private static void SetAsDispTextureToUIRawImage()
    {
        Selection.activeGameObject.AddComponent<DispTextureToUIRawImage>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispTextureToUIRawImage");
    }





    #endregion 



    ////////////////////////////////////文件驱动组件
    #region 文件驱动组件
    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】图片文件夹驱动Renderer[]显示组件/新建", true, 1753)]
    private static bool NewDispTexturesDirectoryToRenderersValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispTexturesDirectoryToRenderers");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】图片文件夹驱动Renderer[]显示组件/新建", false, 1753)]
    private static void NewDispTexturesDirectoryToRenderers()
    {
        GameObject go = new GameObject();
        go.name = "DispTexturesDirectoryToRenderers";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispTexturesDirectoryToRenderers>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispTexturesDirectoryToRenderers");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】图片文件夹驱动Renderer[]显示组件/设置所选", true, 1754)]
    private static bool SetAsDispTexturesDirectoryToRenderersValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispTexturesDirectoryToRenderers");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】图片文件夹驱动Renderer[]显示组件/设置所选", false, 1754)]
    private static void SetAsDispTexturesDirectoryToRenderers()
    {
        Selection.activeGameObject.AddComponent<DispTexturesDirectoryToRenderers>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispTexturesDirectoryToRenderers");
    }


    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】图片地址驱动Renderer[]显示组件/新建", true, 1755)]
    private static bool NewDispTextureUrlsToRenderersValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispTextureUrlsToRenderers");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】图片地址驱动Renderer[]显示组件/新建", false, 1755)]
    private static void NewDispTextureUrlsToRenderers()
    {
        GameObject go = new GameObject();
        go.name = "DispTextureUrlsToRenderers";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispTextureUrlsToRenderers>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispTextureUrlsToRenderers");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】图片地址驱动Renderer[]显示组件/设置所选", true, 1756)]
    private static bool SetAsDispTextureUrlsToRenderersValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispTextureUrlsToRenderers");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】图片地址驱动Renderer[]显示组件/设置所选", false, 1756)]
    private static void SetAsDispTextureUrlsToRenderers()
    {
        Selection.activeGameObject.AddComponent<DispTextureUrlsToRenderers>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispTextureUrlsToRenderers");
    }


    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】txt文件段落驱动显示组件/新建", true, 1755)]
    private static bool NewDispTxtFileToTextComponentsValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeDisp("DispTxtFileToTextComponents");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】txt文件段落驱动显示组件/新建", false, 1755)]
    private static void NewDispTxtFileToTextComponents()
    {
        GameObject go = new GameObject();
        go.name = "DispTxtFileToTextComponents";
        go.transform.SetParent(displayParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<DispTxtFileToTextComponents>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create DispTxtFileToTextComponents");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】txt文件段落驱动显示组件/设置所选", true, 1756)]
    private static bool SetAsDispTxtFileToTextComponentsValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeDisp("DispTxtFileToTextComponents");
    }
    [MenuItem("SpacePlayer/数据呈现驱动/【文件】txt文件段落驱动显示组件/设置所选", false, 1756)]
    private static void SetAsDispTxtFileToTextComponents()
    {
        Selection.activeGameObject.AddComponent<DispTxtFileToTextComponents>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create DispTxtFileToTextComponents");
    }




    #endregion





    ////////////////////////////////////数据存储驱动组件
    #region 数据存储驱动组件

    static bool GettingBaseConditionForCreatingWormholeOut(string compType)
    {
        if (srcTran == null)
        {
            SpaceSourceObj t = FindObjectOfType<SpaceSourceObj>();
            if (t != null)
                srcTran = t.transform;
        }
        if (srcTran == null)
            return false;

        if (dataOutParent  == null)
        {
            dataOutParent = srcTran.Find("DataOutParent");
            if (dataOutParent == null)
            {
                dataOutParent = new GameObject().transform;
                dataOutParent.SetParent(srcTran);
                dataOutParent.localEulerAngles = Vector3.zero;
                dataOutParent.localPosition = Vector3.zero;
                dataOutParent.name = "DataOutParent";
            }
            return false;
        }
        return true;
    }


    static bool GettingBaseConditionForSettingAsWormholeOut(string compType)
    {
        if (srcTran == null)
        {
            SpaceSourceObj t = FindObjectOfType<SpaceSourceObj>();
            if (t != null)
                srcTran = t.transform;
        }
        if (srcTran == null)
            return false;

        if (Selection.activeGameObject == null) return false;     //至少有一个选择物
         
        if (Selection.activeGameObject.GetComponent(compType) != null || Selection.activeGameObject.GetComponent("Wormhole.WOutBase") != null) return false;     //所选物体必须为资源内物体

        return true;
    }


    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】小数到参数字典输出组件/新建", true, 3001)]
    private static bool NewWOutFloatToParamDictionaryValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeOut("WOutFloatToParamDictionary");
    }
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】小数到参数字典输出组件/新建", false, 3001)]
    private static void NewWOutFloatToParamDictionary()
    {
        GameObject go = new GameObject();
        go.name = "WOutFloatToParamDictionary";
        go.transform.SetParent(dataOutParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WOutFloatToParamDictionary>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WOutFloatToParamDictionary");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】小数到参数字典输出组件/设置所选", true, 3002)]
    private static bool SetAsWOutFloatToParamDictionaryValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeOut("WOutFloatToParamDictionary");
    }
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】小数到参数字典输出组件/设置所选", false, 3002)]
    private static void SetAsWOutFloatToParamDictionary()
    {
        Selection.activeGameObject.AddComponent<WOutFloatToParamDictionary>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WOutFloatToParamDictionary");
    }


    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】整数到参数字典输出组件/新建", true, 3003)]
    private static bool NewWOutIntToParamDictionaryValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeOut("WOutIntToParamDictionary");
    }
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】整数到参数字典输出组件/新建", false, 3003)]
    private static void NewWOutIntToParamDictionary()
    {
        GameObject go = new GameObject();
        go.name = "WOutIntToParamDictionary";
        go.transform.SetParent(dataOutParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WOutIntToParamDictionary>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WOutIntToParamDictionary");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】整数到参数字典输出组件/设置所选", true, 3004)]
    private static bool SetAsWOutIntToParamDictionaryValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeOut("WOutIntToParamDictionary");
    }
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】整数到参数字典输出组件/设置所选", false, 3004)]
    private static void SetAsWOutIntToParamDictionary()
    {
        Selection.activeGameObject.AddComponent<WOutIntToParamDictionary>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WOutIntToParamDictionary");
    }


    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】字符串到参数字典输出组件/新建", true, 3005)]
    private static bool NewWOutStringToParamDictionaryValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeOut("WOutStringToParamDictionary");
    }
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】字符串到参数字典输出组件/新建", false, 3005)]
    private static void NewWOutStringToParamDictionary()
    {
        GameObject go = new GameObject();
        go.name = "WOutStringToParamDictionary";
        go.transform.SetParent(dataOutParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WOutStringToParamDictionary>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WOutStringToParamDictionary");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】字符串到参数字典输出组件/设置所选", true, 3006)]
    private static bool SetAsWOutStringToParamDictionaryValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeOut("WOutStringToParamDictionary");
    }
    [MenuItem("SpacePlayer/数据存储驱动/【字典输出】字符串到参数字典输出组件/设置所选", false, 3006)]
    private static void SetAsWOutStringToParamDictionary()
    {
        Selection.activeGameObject.AddComponent<WOutStringToParamDictionary>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WOutStringToParamDictionary");
    }




    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据存储驱动/【文件输出】文本到txt文件输出组件/新建", true, 3101)]
    private static bool NewWOutTextToTxtFileValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeOut("WOutTextToTxtFile");
    }
    [MenuItem("SpacePlayer/数据存储驱动/【文件输出】文本到txt文件输出组件/新建", false, 3101)]
    private static void NewWOutTextToTxtFile()
    {
        GameObject go = new GameObject();
        go.name = "WOutTextToTxtFile";
        go.transform.SetParent(dataOutParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WOutTextToTxtFile>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WOutTextToTxtFile");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据存储驱动/【文件输出】文本到txt文件输出组件/设置所选", true, 3102)]
    private static bool SetAsWOutTextToTxtFileValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeOut("WOutTextToTxtFile");
    }
    [MenuItem("SpacePlayer/数据存储驱动/【文件输出】文本到txt文件输出组件/设置所选", false, 3102)]
    private static void SetAsWOutTextToTxtFile()
    {
        Selection.activeGameObject.AddComponent<WOutTextToTxtFile>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WOutTextToTxtFile");
    }





    ////////////////////////////////////////////////////////////////////////////////////////////
    [MenuItem("SpacePlayer/数据存储驱动/【文件输出】Texture到png文件输出组件/新建", true, 3111)]
    private static bool NewWOutTextureToPngFileValidateFunc()
    {
        return GettingBaseConditionForCreatingWormholeOut("WOutTextureToPngFile");
    }
    [MenuItem("SpacePlayer/数据存储驱动/【文件输出】Texture到png文件输出组件/新建", false, 3111)]
    private static void NewWOutTextureToPngFile()
    {
        GameObject go = new GameObject();
        go.name = "WOutTextureToPngFile";
        go.transform.SetParent(dataOutParent);
        go.transform.localPosition = Vector3.zero;
        go.transform.localEulerAngles = Vector3.zero;
        go.AddComponent<WOutTextureToPngFile>();

        // 注册撤销操作
        Undo.RegisterCreatedObjectUndo(go, "Create WOutTextureToPngFile");
        Selection.activeGameObject = go;
    }
    [MenuItem("SpacePlayer/数据存储驱动/【文件输出】Texture到png文件输出组件/设置所选", true, 3112)]
    private static bool SetAsWOutTextureToPngFileValidateFunc()
    {
        return GettingBaseConditionForSettingAsWormholeOut("WOutTextureToPngFile");
    }
    [MenuItem("SpacePlayer/数据存储驱动/【文件输出】Texture到png文件输出组件/设置所选", false, 3112)]
    private static void SetAsWOutTextureToPngFile()
    {
        Selection.activeGameObject.AddComponent<WOutTextureToPngFile>();
        Undo.RegisterCreatedObjectUndo(Selection.activeGameObject, "Create WOutTextureToPngFile");
    }




    #endregion 

    /////////////////////////////////////////////////////////////////////////////////////////////////////////
    //[MenuItem("SpacePlayer/数据虫洞/检查在编资源的数据虫洞是否存在常见问题", true, 900)]
    //private static bool PreCheckProblemInValidateFunc()
    //{
    //    return true;
    //}

    //[MenuItem("SpacePlayer/数据虫洞/检查在编资源的数据虫洞是否存在常见问题", false, 900)]
    //static void PreCheckProblemInSrc()
    //{
    //    //CheckToRemoveMovieRecorder();

    //    if (null == srcTran )
    //    {
    //        EditorUtility.DisplayDialog("没有在当前场景中找到空间播放资源体", "没有在当前场景中找到空间播放资源体，检查无法进行，请先打开要检查的资源体所在的scene场景。", "确定");
    //        return;
    //    }

    //    //检查确保所有东西都要在Src之下 // 获取当前场景的根物体列表
    //    GameObject[] rootObjects = UnityEngine.SceneManagement.SceneManager.GetActiveScene().GetRootGameObjects();
    //    if (rootObjects.Length != 2)
    //    {
    //        if (EditorUtility.DisplayDialog("【警告】", "标准的编辑场景的根级物体有且只有两个，请检查下要编辑的所有物体是否都在CustomObjSrc脚本物体之下。", "确定", "忽略"))
    //        {
    //            Selection.activeGameObject = srcTran.gameObject;
    //            return;
    //        }
    //    }

    //    ////
    //    ////GeneralEventActor[] eventActors = curMainSrc.GetComponentsInChildren<GeneralEventActor>(true);
    //    //for (int i = 0, length = eventActors.Length; i < length; i++)
    //    //{
    //    //    string strTemp = SPEditor_GeneralTools.JudgeProblemAtGeneralEventActor(eventActors[i]);
    //    //    if (string .IsNullOrEmpty(strTemp ) )
    //    //    {
    //    //        if (EditorUtility.DisplayDialog("【警告】", strTemp, "确定", "忽略"))
    //    //        {
    //    //            Selection.activeGameObject = curMainSrc.gameObject;
    //    //            return;
    //    //        }
    //    //    }
    //    //    string strStr = SPEditor_GeneralTools.ExistOtherSameTranPath(curMainSrc.transform, eventActors[i].transform);
    //    //    if (!string.IsNullOrEmpty(strStr))
    //    //    {
    //    //        EditorUtility.DisplayDialog("【警告】层级路径存在同名", strStr, "确定");
    //    //        Selection.activeGameObject = eventActors[i].gameObject;
    //    //        return;
    //    //    }
    //    //}



    //    //GeneralTrigger[] triggers = curMainSrc.GetComponentsInChildren<GeneralTrigger>(true);
    //    //for (int i = 0, length = triggers.Length; i < length; i++)
    //    //{
    //    //    string strTemp = SPEditor_GeneralTools.JudgeProblemAtGeneralTrigger(triggers[i]);
    //    //    if (string.IsNullOrEmpty(strTemp))
    //    //    {
    //    //        if (EditorUtility.DisplayDialog("【警告】", strTemp, "确定", "忽略"))
    //    //        {
    //    //            Selection.activeGameObject = curMainSrc.gameObject;
    //    //            return;
    //    //        }
    //    //    }
    //    //}

    //    //string errMsg = SPEditor_GeneralTools.JudgeProblemAtGeneralExtMediaActor(curMainSrc.transform);
    //    //if (!string.IsNullOrEmpty(errMsg))
    //    //{
    //    //    if (EditorUtility.DisplayDialog("【警告】", errMsg, "确定", "忽略"))
    //    //    {
    //    //        Selection.activeGameObject = curMainSrc.gameObject;
    //    //        return;
    //    //    }
    //    //}


    //    EditorUtility.DisplayDialog("预检完成", "未发现常见的错误，可以选中资源Prefab，通过菜单开始打包。", "确定");
    //}


    #region 打包输出

    internal  static void CopySrc(DirectoryInfo di,GameObject  obj)
    {
        //GameObject go = obj as GameObject;
        if (null == obj)
            Debug.LogWarning("没有在当前场景中找到对应的结构根物体，未能检查场景中的预制体实例更改是否已经全部更新到预制体上了，但并没影响打包。");

        /////开始输出
        Debug.Log("obj.name:"+ obj.name ); 
        string fileName = obj.name.ToLower() + ".sps";
        if (!SPEditor_GeneralTools.Create3DSourceFolder(di, fileName)) return;

        ///拷贝数据虫洞指定的资源
        DispTexturesDirectoryToRenderers[] dtdtr = obj.GetComponentsInChildren<DispTexturesDirectoryToRenderers>(true );
        for (int i = 0, length = dtdtr.Length; i < length; i++)
        {
            Debug.Log("拷贝DispTexturesDirectoryToRenderers文件上的资源路径,载体物体：" + dtdtr[i].gameObject.name);
            CopyRefFile(dtdtr[i].outDirType, dtdtr[i].middlePath,  di.FullName );
        }

        DispTxtFileToTextComponents[] dtfttc = obj.GetComponentsInChildren<DispTxtFileToTextComponents>(true);
        for (int i = 0, length = dtfttc.Length; i < length; i++)
        {
            Debug.Log("拷贝DispTxtFileToTextComponents文件上的资源路径,载体物体：" + dtfttc[i].gameObject.name + "---middlePath:" + dtfttc[i].pathInDir); 
            CopyRefFile(dtfttc[i].dirType , dtfttc[i].pathInDir, di.FullName);
        }

        WmhXmlContentToXmlNode [] wxctxn = obj.GetComponentsInChildren<WmhXmlContentToXmlNode>(true);
        for (int i = 0, length = wxctxn.Length; i < length; i++)
        {
            Debug.Log("拷贝WmhXmlContentToXmlNode文件上的资源路径,载体物体：" + wxctxn[i].gameObject.name + "---middlePath:" + wxctxn[i].xmlUrlInDirector);
            CopyRefFile(wxctxn[i].targetDirType , wxctxn[i].XmlUrlInDirector, di.FullName);
        }

    }

   

    static void CopyRefFile(DirType dirType, string _filePath, string targetDir) 
    {
        string _fullPath = "";
        string _targetpath = Path.Combine (targetDir, _filePath);

        switch (dirType)
        {
            case DirType.Desktop:
                _fullPath = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.Desktop), Application.productName, _filePath);
                break;

            case DirType.Document:
                _fullPath = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments), Application.productName, _filePath);
                break;

            case DirType.StreamingAssets:
                _fullPath = Path.Combine(Application.streamingAssetsPath , _filePath);
                break;

            case DirType.AppPersistantPath:
                _fullPath = Path.Combine(Application .persistentDataPath, Application.productName, _filePath);
                break;

            case DirType.AppRootPath:
                _fullPath = Path.Combine(Application.dataPath ,  _filePath);
                break;

            case DirType.MainSourcePath:
                _fullPath = Path.Combine(Application.streamingAssetsPath, _filePath);
                break;

            case DirType.Absolute:
            default:
                _fullPath = _filePath;
                break;
        }

        if(Directory.Exists (_fullPath ))
        {
            CopyFolder(_fullPath, _targetpath);
        }
        else if (File.Exists(_fullPath))
        {
            if (!File.Exists(_targetpath))    //存在的话不重复拷贝
            {
                Debug.Log("_fullPath:"+ _fullPath);
                Debug.Log("_targetpath:"+ _targetpath);
                //File.Copy(_fullPath, _targetpath,true );
                CopyFileWithFolderCreation(_fullPath, _targetpath);
            }

            if (Path.GetExtension(_fullPath).ToLower() == ".xml")    //xml要深入其中将XMLNode中的资源地址都拷贝下来
            {
                XmlDocument xDoc = new XmlDocument();
                xDoc.Load(_fullPath);
                XmlNode xn = xDoc.DocumentElement;
                RecognizeFilesInXMLNode(xn, dirType, _filePath, targetDir);
            }
        }
        else
        {
            Debug.Log("脚本引用的文件【" + _fullPath + "】不存在。未正确拷贝到目标位置【"+ _targetpath + "】请在打包完毕后自行拷贝到目标文件夹下" );
            //EditorUtility.DisplayDialog("找不到文件", "脚本引用的文件【" + _fullPath + "】不存在。请在打包完毕后自行拷贝到目标文件夹下", "确定");
        }
    }

    static void CopyFileWithFolderCreation(string sourceFilePath, string destinationFilePath)
    {
        // 检查源文件是否存在
        if (!File.Exists(sourceFilePath))
        {
            //Console.WriteLine($"Source file does not exist: {sourceFilePath}");
            return;
        }

        // 获取目标文件的目录路径
        string destinationDirectory = Path.GetDirectoryName(destinationFilePath);

        // 如果目标目录不存在，则创建它
        if (!Directory.Exists(destinationDirectory))
        {
            Directory.CreateDirectory(destinationDirectory);
            //Console.WriteLine($"Created directory: {destinationDirectory}");
        }

        // 拷贝文件
        File.Copy(sourceFilePath, destinationFilePath, true); // true表示如果目标文件存在则覆盖
        //Console.WriteLine($"File copied from {sourceFilePath} to {destinationFilePath}");
    }

    static void RecognizeFilesInXMLNode(XmlNode xn, DirType dirType, string _filePath, string targetDir)
    {
        if(xn.ChildNodes .Count > 0)
        {
            for (int i = 0,length = xn.ChildNodes .Count ; i < length; i++)
            {
                XmlNode xnt = xn.ChildNodes[i];
                RecognizeFilesInXMLNode(xnt, dirType, _filePath, targetDir);
            }
        }
        else    //没有子节点了的话，直接开始筹备拷贝文件了
        {
            string innerText = xn.InnerText;
            // 正则表达式匹配Windows文件路径
            string pattern = @"^([a-zA-Z]:\\|/)?([\w\s.-]+[\\/])*[\w\s.-]+\.[\w]+$";
            if (Regex.IsMatch(innerText, pattern))    //检测是否是文件路径
            {
                Debug.Log("innerText=" + innerText + "，是一个文件路径；dirType: "+ dirType.ToString ());
                CopyRefFile(dirType, innerText, targetDir);
            }
            //else
            //{
            //    Debug.Log("innerText=" + innerText + "，不是一个文件路径");
            //}
        }
    }

    /// <summary>
    /// 从一个文件夹将文件拷贝到另外一个文件夹
    /// </summary>
    /// <param name="sourcePath"></param>
    /// <param name="destinationPath"></param>
    public static void CopyFolder(string sourcePath, string destinationPath)
    {
        // 检查源路径是否存在
        if (!Directory.Exists(sourcePath))
        {
            Debug.LogError("Source folder does not exist: " + sourcePath);
            return;
        }

        // 如果目标路径不存在，则创建它
        if (!Directory.Exists(destinationPath))
        {
            Directory.CreateDirectory(destinationPath);
        }

        // 获取源文件夹中的所有文件
        string[] files = Directory.GetFiles(sourcePath, "*.*", SearchOption.AllDirectories);

        foreach (string file in files)
        {
            // 计算目标文件路径
            string relativePath = file.Substring(sourcePath.Length + 1);
            string destinationFilePath = Path.Combine(destinationPath, relativePath);

            // 确保目标文件夹存在
            string destinationDirectory = Path.GetDirectoryName(destinationFilePath);
            if (!Directory.Exists(destinationDirectory))
            {
                Directory.CreateDirectory(destinationDirectory);
            }

            // 复制文件
            File.Copy(file, destinationFilePath, true);
        }

        Debug.Log("Folder copied successfully from " + sourcePath + " to " + destinationPath);
    }



    //static void CreateConfigFile(GameObject go, string _targetPath)
    //{
    //    //GameObject go = Selection.activeObject as GameObject;
    //    SpaceSourceObj src = go.GetComponent<SpaceSourceObj>();
    //    //判断对象是否可以创建xml文件
    //    if (src != null)
    //    {
    //        XmlDocument xml = new XmlDocument();//初始化新的节点

    //        XmlDeclaration xmlDeclaration = xml.CreateXmlDeclaration("1.0", "utf-8", null);
    //        xml.InsertBefore(xmlDeclaration, xml.DocumentElement);

    //        XmlElement root = xml.CreateElement("spaceSourceObj");//创建StructSrc初始节点
    //        //root.SetAttribute("tranPath", src.transform.name);

    //        root.SetAttribute("editorVersion", SPEditor_GeneralTools.GetEditorVersion());

    //        GeneralEventActor[] cusoEventActors = go.GetComponentsInChildren<GeneralEventActor>(true);
    //        for (int j = 0, max = cusoEventActors.Length; j < max; j++)
    //        {
    //            XmlElement cusoEventActorXE = xml.CreateElement("eventActor");

    //            cusoEventActorXE.SetAttribute("tranPath", SPEditor_GeneralTools.GetTranPath(src.transform, cusoEventActors[j].transform));
    //            cusoEventActorXE.SetAttribute("actorName", cusoEventActors[j].actorName);
    //            root.AppendChild(cusoEventActorXE);
    //        }



    //        xml.AppendChild(root);

    //        ////把通用任务步骤的信息读进来
    //        //SPEditor_ActionTool.CreateCommonMissionSrcConfigInfo(xml, root, go);

    //        using (StreamWriter writer = new StreamWriter(_targetPath, false, new UTF8Encoding(false)))
    //        {
    //            xml.Save(writer);
    //        }
    //    }
    //    else
    //    {
    //        Debug.Log(go.name + "对象不可创建配置文件");
    //    }
    //}
    #endregion


}

