﻿using UnityEditor;
using UnityEngine;
using System.Collections;
using System.IO;

namespace ISVREditor_Utility
{
    public class SPEditorIndex : EditorWindow
    {
        static SPEditorIndex window;

        static string indexPageUrl = "ISPlayer/Editor/Src/WeChat.png";
        static Texture2D indexPageTex2D;

        [MenuItem("SpacePlayer/关于",false  ,9901)]
        public static void Init()
        {
            if (null == indexPageTex2D)
            {
                indexPageUrl = Path.Combine(Application.dataPath, indexPageUrl);
                //Debug.Log("indexPageUrl : " + indexPageUrl);
                if (File.Exists(indexPageUrl))
                {
                    LoadByIo(indexPageUrl);
                }
            }

            if (window != null)
            {
                window.Repaint();
            }
            else
            {
                window = (SPEditorIndex)CreateWindow<SPEditorIndex>();   // (typeof(HMXREditorIndex));
                window.titleContent = new GUIContent("SpacePlayer" );
            }
            window.Show();
        }

        void OnInspectorUpdate()
        {
            // Call Repaint on OnInspectorUpdate as it repaints the windows
            // less times as if it was OnGUI/Update
            Repaint();

            if (window != null)
            {
                window.titleContent = new GUIContent("SpacePlayer" );
            }
        }

        

        private void Update()
        {
        }

        void OnGUI()
        {
            GUILayout.BeginVertical ();

            GUILayout.Space(10);
            if (null != indexPageTex2D)
            {
                GUILayout.BeginHorizontal(GUILayout.Height (256));
                GUILayout.FlexibleSpace();
                GUILayout.Label(indexPageTex2D,GUILayout.Width(256),GUILayout.Height (256));
                GUILayout.FlexibleSpace();
                GUILayout.EndHorizontal();
            }

            GUILayout.Space(10);

            GUILayout.BeginHorizontal();
            GUILayout.Label("版权所有", GUILayout.Width(64)); 
            GUILayout.Label("遥知");
            GUILayout.EndHorizontal();

            GUILayout.Space(10);

            GUILayout.BeginHorizontal();
            GUILayout.Label("公司官网",GUILayout.Width (64));
            if (GUILayout.Button("www.teachf.com"))
            {
                Application.OpenURL("www.teachf.com");
            }
            GUILayout.EndHorizontal();

            GUILayout.Space(10);
                        
            GUILayout.EndVertical();
        }

        /// <summary>
        /// 以IO方式进行加载
        /// </summary>
        private static void LoadByIo(string url)
        {
            //创建文件读取流
            FileStream fileStream = new FileStream(url, FileMode.Open, FileAccess.Read);
            //创建文件长度缓冲区
            byte[] bytes = new byte[fileStream.Length];
            //读取文件
            fileStream.Read(bytes, 0, (int)fileStream.Length);

            //释放文件读取流
            fileStream.Close();
            //释放本机屏幕资源
            fileStream.Dispose();
            fileStream = null;

            //创建Texture
            int width = 256;
            int height = 256;
            indexPageTex2D = new Texture2D(width, height);
            indexPageTex2D.LoadImage(bytes);
            Debug.Log("Index图加载成功");

        }

    }

}