﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;
using System.IO;
using DllUtility;

//namespace DllUtility
//{
    public class DllAssembleEditor : MonoBehaviour
    {
    //const string dllPluginFolderName = "DllPlugins";


    [MenuItem("SpacePlayer/程序热更/选.asmdef文件生成或刷新热更程序集", true, 8020)]
    static bool BuildAssemblyDllValid()
    {
        if (Selection.activeObject == null) return false;
        //Debug.Log("Selection.activeObject " + Selection.activeObject.name);
        string path = AssetDatabase.GetAssetPath(Selection.activeObject);
        if (string.IsNullOrEmpty(path)) return false;

        string _extName = Path.GetExtension(path);
        if (string.IsNullOrEmpty(_extName)) return false;

        if (_extName != ".asmdef") return false;
        //Debug.Log("_extName " + _extName);
        return true;
    }

    [MenuItem("SpacePlayer/程序热更/选.asmdef文件生成或刷新热更程序集", false,8020)]
    static void BuildAssemblyDll()
    {
        string path = AssetDatabase.GetAssetPath(Selection.activeObject);
        string _name = Path.GetFileNameWithoutExtension(path);
        DirectoryInfo di = new DirectoryInfo(Application.dataPath);
        string dllUrl = Path.Combine(di.Parent.FullName, "Library/ScriptAssemblies", _name + ".dll");

        FileInfo fi = new FileInfo(dllUrl);
        if (!fi.Exists)
        {
            Debug.LogError("请先等待该程序集编译完成");
            return;
        }

        string dllTxtPath = path.Replace(".asmdef", "Dll.bytes");
        File.Copy(dllUrl, dllTxtPath, true);

        dllUrl = Path.Combine(di.Parent.FullName, "Library/ScriptAssemblies", _name + ".pdb");
        dllTxtPath = path.Replace(".asmdef", "Pdb.bytes");
        File.Copy(dllUrl, dllTxtPath, true);

        AssetDatabase.Refresh();

        EditorUtility.DisplayDialog("热更程序集创建完成", "热更程序集创建完成", "确定");
    }


        [MenuItem("SpacePlayer/程序热更/添加热更组件ILComponent", true , 8021)]
        public static bool AddDllComponentValid()
        {
            if (Selection.activeGameObject  == null) return false;

            return true;
        }


        [MenuItem("SpacePlayer/程序热更/添加热更组件ILComponent", false , 8021)]
        public static void AddDllComponent()
        {
            string path = EditorUtility.OpenFilePanel("选择要指定的程序集文件(.bytes)",
                   Path.Combine(Application.dataPath),
                   "bytes");
            path = "Assets/" + path.Remove(0, Application.dataPath.Length + 1);
            string pdbPath = path.Replace("Dll.bytes", "Pdb.bytes");

            for (int i = 0,length =Selection.gameObjects.Length  ; i < length; i++)
            {
                ILComponent dllComp = Selection.gameObjects[i].AddComponent<ILComponent>();
                dllComp.textAsset = AssetDatabase.LoadAssetAtPath<TextAsset>(path );
                dllComp.pdbAsset = AssetDatabase.LoadAssetAtPath<TextAsset>(pdbPath);
            }

            EditorUtility.DisplayDialog("添加完毕", "添加热更组件ILComponent完毕，请配置使用。", "确定");
        }


        [MenuItem("SpacePlayer/程序热更/添加静态热更组件ILStaticComponent", true , 8022)]
        public static bool AddILStaticComponentValid()
        {
            if (Selection.activeGameObject == null) return false;

            return true;
        }


        [MenuItem("SpacePlayer/程序热更/添加静态热更组件ILStaticComponent", false , 8022)]
        public static void AddILStaticComponent()
        {
            string path = EditorUtility.OpenFilePanel("选择要指定的程序集文件(.bytes)",
                   Path.Combine(Application.dataPath),
                   "bytes");
            path = "Assets/" + path.Remove(0, Application.dataPath.Length + 1);
            string pdbPath = path.Replace("Dll.bytes", "Pdb.bytes");

            for (int i = 0, length = Selection.gameObjects.Length; i < length; i++)
            {
                ILStaticComponent  dllComp = Selection.gameObjects[i].AddComponent<ILStaticComponent>();
                dllComp.textAsset = AssetDatabase.LoadAssetAtPath<TextAsset>(path);
                dllComp.pdbAsset = AssetDatabase.LoadAssetAtPath<TextAsset>(pdbPath);
            }
            EditorUtility.DisplayDialog("添加完毕", "添加静态热更组件ILStaticComponent完毕，请配置使用。", "确定");
        }


        [MenuItem("SpacePlayer/程序热更/添加热更跨域继承类HotFixInheritComponent", true , 8023)]
        public static bool AddHotFixInheritComponentValid()
        {
            if (Selection.activeGameObject == null) return false;

            return true;
        }


        [MenuItem("SpacePlayer/程序热更/添加热更跨域继承类HotFixInheritComponent", false, 8023)]
        public static void AddHotFixInheritComponent()
        {
            string path = EditorUtility.OpenFilePanel("选择要指定的程序集文件(.bytes)",
                   Path.Combine(Application.dataPath),
                   "bytes");
            path = "Assets/" + path.Remove(0, Application.dataPath.Length + 1);
            string pdbPath = path.Replace("Dll.bytes", "Pdb.bytes");

            for (int i = 0, length = Selection.gameObjects.Length; i < length; i++)
            {
                HotFixInheritComponent  dllComp = Selection.gameObjects[i].AddComponent<HotFixInheritComponent>();
                dllComp.textAsset = AssetDatabase.LoadAssetAtPath<TextAsset>(path);
                dllComp.pdbAsset = AssetDatabase.LoadAssetAtPath<TextAsset>(pdbPath);
            }
            EditorUtility.DisplayDialog("添加完毕", "添加热更跨域继承类HotFixInheritComponent完毕，请配置使用。", "确定");
        }


        //[MenuItem("SpacePlayer/程序热更/检查热更组件参数是否完备")]
        //public static void UpdateDllComponentURL()
        //{
        //    ILComponent[] dllComps = FindObjectsOfType<ILComponent>();

        //    List<GameObject> gs = new List<GameObject>();
        //    for (int i = 0, length = dllComps.Length; i < length; i++)
        //    {
        //        ILComponent dc = dllComps[i];
        //        if(dc.textAsset == null )
        //            gs.Add(dc.gameObject);
        //    }

        //    if (gs.Count > 0)
        //    {
        //        Selection.objects = gs.ToArray();
        //        Debug.LogError("选中物体的热更组件没有指定对应的Dll.bytes文件");
        //    }
        //    else
        //        EditorUtility.DisplayDialog("检查完毕", "所有热更组件都指定了对应的Dll.bytes文件", "确定");
        //}

    }

//}