﻿
using System;
using System.Runtime.InteropServices;

#pragma warning disable 1591

namespace OpenCvSharp
{
    // ReSharper disable InconsistentNaming

    static partial class NativeMethods
    {
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern void face_FaceRecognizer_train(
            IntPtr obj, IntPtr[] src, int srcLength, int[] labels, int labelsLength);
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern void face_FaceRecognizer_update(
            IntPtr obj, IntPtr[] src, int srcLength, int[] labels, int labelsLength);
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern int face_FaceRecognizer_predict1(IntPtr obj, IntPtr src);
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern void face_FaceRecognizer_predict2(
            IntPtr obj, IntPtr src, out int label, out double confidence);
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern void face_FaceRecognizer_save1(IntPtr obj, string filename);
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern void face_FaceRecognizer_load1(IntPtr obj, string filename);
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern void face_FaceRecognizer_save2(IntPtr obj, IntPtr fs);
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern void face_FaceRecognizer_load2(IntPtr obj, IntPtr fs);

        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern void face_FaceRecognizer_setLabelInfo(IntPtr obj, int label,
            [MarshalAs(UnmanagedType.LPStr)] string strInfo);
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern void face_FaceRecognizer_getLabelInfo(IntPtr obj, int label, IntPtr dst);
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern void face_FaceRecognizer_getLabelsByString(IntPtr obj,
            [MarshalAs(UnmanagedType.LPStr)] string str, IntPtr dst);
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern double face_FaceRecognizer_getThreshold(IntPtr obj);
        [DllImport(DllExtern, CallingConvention = CallingConvention.Cdecl, ExactSpelling = true)]
        public static extern void face_FaceRecognizer_setThreshold(IntPtr obj, double val);
    }
}