/*
 * Decompiled with CFR 0.152.
 */
package com.yasirkula.unity;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.DocumentsContract;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;

@TargetApi(value=29)
public class FileBrowserSAFEntry {
    private static final String TAG = "DocumentFile";
    private Context mContext;
    private Uri mUri;

    public static FileBrowserSAFEntry fromTreeUri(Context context, Uri uri) {
        if ((uri = DocumentsContract.buildDocumentUriUsingTree((Uri)uri, (String)DocumentsContract.getTreeDocumentId((Uri)uri))) == null) {
            return null;
        }
        return new FileBrowserSAFEntry(context, uri);
    }

    public FileBrowserSAFEntry(Context context, Uri uri) {
        this.mContext = context;
        this.mUri = uri;
    }

    public FileBrowserSAFEntry createFile(String mimeType, String displayName) {
        try {
            Uri result = DocumentsContract.createDocument((ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri, (String)mimeType, (String)displayName);
            return result != null ? new FileBrowserSAFEntry(this.mContext, result) : null;
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
            return null;
        }
    }

    public FileBrowserSAFEntry createDirectory(String displayName) {
        try {
            Uri result = DocumentsContract.createDocument((ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri, (String)"vnd.android.document/directory", (String)displayName);
            return result != null ? new FileBrowserSAFEntry(this.mContext, result) : null;
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
            return null;
        }
    }

    public Uri getUri() {
        return this.mUri;
    }

    public String getName() {
        return this.queryForString("_display_name", null);
    }

    public String getType() {
        String rawType = this.getRawType();
        if ("vnd.android.document/directory".equals(rawType)) {
            return null;
        }
        return rawType;
    }

    public boolean isDirectory() {
        return "vnd.android.document/directory".equals(this.getRawType());
    }

    public boolean isFile() {
        String type = this.getRawType();
        return !"vnd.android.document/directory".equals(type) && !TextUtils.isEmpty((CharSequence)type);
    }

    public long lastModified() {
        return this.queryForLong("last_modified", 0L);
    }

    public long length() {
        return this.queryForLong("_size", 0L);
    }

    public boolean canRead() {
        if (this.mContext.checkCallingOrSelfUriPermission(this.mUri, 1) != 0) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)this.getRawType());
    }

    public boolean canWrite() {
        if (this.mContext.checkCallingOrSelfUriPermission(this.mUri, 2) != 0) {
            return false;
        }
        String type = this.getRawType();
        int flags = this.queryForInt("flags", 0);
        if (TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        if ((flags & 4) != 0) {
            return true;
        }
        if ("vnd.android.document/directory".equals(type) && (flags & 8) != 0) {
            return true;
        }
        return !TextUtils.isEmpty((CharSequence)type) && (flags & 2) != 0;
    }

    public boolean delete() {
        try {
            return DocumentsContract.deleteDocument((ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri);
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        ContentResolver resolver = this.mContext.getContentResolver();
        Cursor c = null;
        try {
            c = resolver.query(this.mUri, new String[]{"document_id"}, null, null, null);
            boolean bl = c.getCount() > 0;
            return bl;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Failed query: " + e));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<FileBrowserSAFEntry> listFiles() {
        ContentResolver resolver = this.mContext.getContentResolver();
        Uri childrenUri = DocumentsContract.buildChildDocumentsUriUsingTree((Uri)this.mUri, (String)DocumentsContract.getDocumentId((Uri)this.mUri));
        ArrayList<FileBrowserSAFEntry> results = new ArrayList<FileBrowserSAFEntry>();
        Cursor c = null;
        try {
            c = resolver.query(childrenUri, new String[]{"document_id"}, null, null, null);
            while (c.moveToNext()) {
                String documentId = c.getString(0);
                Uri documentUri = DocumentsContract.buildDocumentUriUsingTree((Uri)this.mUri, (String)documentId);
                results.add(new FileBrowserSAFEntry(this.mContext, documentUri));
            }
        }
        catch (Exception e) {
            Log.w((String)"Unity", (String)("Failed query: " + e));
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception:", (Throwable)e);
            }
        }
        return results;
    }

    public String renameTo(String displayName) {
        try {
            Uri result = DocumentsContract.renameDocument((ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri, (String)displayName);
            if (result != null) {
                this.mUri = result;
            }
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
        }
        return this.mUri.toString();
    }

    private String getRawType() {
        return this.queryForString("mime_type", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryForString(String column, String defaultValue) {
        ContentResolver resolver = this.mContext.getContentResolver();
        Cursor c = null;
        try {
            c = resolver.query(this.mUri, new String[]{column}, null, null, null);
            if (c.moveToFirst() && !c.isNull(0)) {
                String string = c.getString(0);
                return string;
            }
            String string = defaultValue;
            return string;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Failed query: " + e));
            String string = defaultValue;
            return string;
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception:", (Throwable)e);
            }
        }
    }

    private int queryForInt(String column, int defaultValue) {
        return (int)this.queryForLong(column, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long queryForLong(String column, long defaultValue) {
        ContentResolver resolver = this.mContext.getContentResolver();
        Cursor c = null;
        try {
            c = resolver.query(this.mUri, new String[]{column}, null, null, null);
            if (c.moveToFirst() && !c.isNull(0)) {
                long l = c.getLong(0);
                return l;
            }
            long l = defaultValue;
            return l;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Failed query: " + e));
            long l = defaultValue;
            return l;
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception:", (Throwable)e);
            }
        }
    }
}

