/*
 * Decompiled with CFR 0.152.
 */
package com.yasirkula.unity;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.yasirkula.unity.FileBrowserDirectoryReceiver;
import com.yasirkula.unity.FileBrowserSAFEntry;

@TargetApi(value=29)
public class FileBrowserDirectoryPickerFragment
extends Fragment {
    private static final int DIRECTORY_PICK_REQUEST_CODE = 74425;
    private final FileBrowserDirectoryReceiver directoryReceiver;

    public FileBrowserDirectoryPickerFragment() {
        this.directoryReceiver = null;
    }

    public FileBrowserDirectoryPickerFragment(FileBrowserDirectoryReceiver directoryReceiver) {
        this.directoryReceiver = directoryReceiver;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.directoryReceiver == null) {
            this.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
        } else {
            Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
            intent.addFlags(67);
            intent.putExtra("android.content.extra.SHOW_ADVANCED", true);
            intent.putExtra("android.content.extra.FANCY", true);
            intent.putExtra("android.content.extra.SHOW_FILESIZE", true);
            intent.putExtra("android.intent.extra.LOCAL_ONLY", true);
            this.startActivityForResult(intent, 74425);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        FileBrowserSAFEntry directory;
        Uri directoryUri;
        if (requestCode != 74425) {
            return;
        }
        String rawUri = "";
        String name = "";
        if (resultCode == -1 && data != null && (directoryUri = data.getData()) != null && (directory = FileBrowserSAFEntry.fromTreeUri((Context)this.getActivity(), directoryUri)) != null && directory.exists()) {
            rawUri = directory.getUri().toString();
            name = directory.getName();
            this.getActivity().getContentResolver().takePersistableUriPermission(data.getData(), 3);
        }
        if (this.directoryReceiver != null) {
            this.directoryReceiver.OnDirectoryPicked(rawUri, name);
        }
        this.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
    }
}

