/*
 * Decompiled with CFR 0.152.
 */
package com.yasirkula.unity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.UriPermission;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.yasirkula.unity.FileBrowserDirectoryPickerFragment;
import com.yasirkula.unity.FileBrowserDirectoryReceiver;
import com.yasirkula.unity.FileBrowserPermissionFragment;
import com.yasirkula.unity.FileBrowserPermissionReceiver;
import com.yasirkula.unity.FileBrowserSAFEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class FileBrowser {
    private static final StringBuilder stringBuilder = new StringBuilder();

    public static String GetExternalDrives() {
        String[] possibleRoots;
        File primary = Environment.getExternalStorageDirectory();
        String primaryPath = primary.getAbsolutePath();
        stringBuilder.setLength(0);
        stringBuilder.append(primaryPath).append(":");
        String strSDCardPath = System.getenv("SECONDARY_STORAGE");
        if (strSDCardPath == null || strSDCardPath.length() == 0) {
            strSDCardPath = System.getenv("EXTERNAL_SDCARD_STORAGE");
        }
        if (strSDCardPath != null && strSDCardPath.length() > 0) {
            String[] externalPaths = strSDCardPath.split(":");
            for (int i = 0; i < externalPaths.length; ++i) {
                String absolutePath;
                File file;
                String path = externalPaths[i];
                if (path == null || path.length() <= 0 || !(file = new File(path)).exists() || !file.isDirectory() || !file.canRead() || file.getAbsolutePath().equalsIgnoreCase(primaryPath) || !new File(absolutePath = file.getAbsolutePath() + File.separator + "Android").exists()) continue;
                try {
                    if (primary.getCanonicalPath().equals(file.getCanonicalPath())) continue;
                    stringBuilder.append(file.getAbsolutePath()).append(":");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        for (String root : possibleRoots = new String[]{"/storage", "/mnt", "/storage/removable", "/removable", "/data", "/mnt/media_rw", "/mnt/sdcard0"}) {
            try {
                File[] fileList;
                for (File file : fileList = new File(root).listFiles()) {
                    String absolutePath;
                    if (!file.exists() || !file.isDirectory() || !file.canRead() || file.getAbsolutePath().equalsIgnoreCase(primaryPath) || !new File(absolutePath = file.getAbsolutePath() + File.separator + "Android").exists()) continue;
                    try {
                        if (primary.getCanonicalPath().equals(file.getCanonicalPath())) continue;
                        stringBuilder.append(file.getAbsolutePath()).append(":");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    @TargetApi(value=23)
    public static int CheckPermission(Context context) {
        if (Build.VERSION.SDK_INT < 23) {
            return 1;
        }
        if (context.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0 && context.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") == 0) {
            return 1;
        }
        return 0;
    }

    public static void RequestPermission(Context context, FileBrowserPermissionReceiver permissionReceiver, int lastCheckResult) {
        if (FileBrowser.CheckPermission(context) == 1) {
            permissionReceiver.OnPermissionResult(1);
            return;
        }
        if (lastCheckResult == 0) {
            permissionReceiver.OnPermissionResult(0);
            return;
        }
        FileBrowserPermissionFragment request = new FileBrowserPermissionFragment(permissionReceiver);
        ((Activity)context).getFragmentManager().beginTransaction().add(0, (Fragment)request).commit();
    }

    public static boolean CheckSAF() {
        return Build.VERSION.SDK_INT >= 29 && !Environment.isExternalStorageLegacy();
    }

    @TargetApi(value=29)
    public static void PickSAFFolder(Context context, FileBrowserDirectoryReceiver directoryReceiver) {
        FileBrowserDirectoryPickerFragment request = new FileBrowserDirectoryPickerFragment(directoryReceiver);
        ((Activity)context).getFragmentManager().beginTransaction().add(0, (Fragment)request).commit();
    }

    @TargetApi(value=29)
    public static String FetchSAFQuickLinks(Context context) {
        int maxPersistedUriPermissions = 5;
        stringBuilder.setLength(0);
        List uriPermissions = context.getContentResolver().getPersistedUriPermissions();
        uriPermissions.sort(new UriPermissionSorter());
        int count = 0;
        for (int i = 0; i < uriPermissions.size(); ++i) {
            UriPermission uriPermission = (UriPermission)uriPermissions.get(i);
            if (count >= 5 || uriPermission.getPersistedTime() == Long.MIN_VALUE || !uriPermission.isReadPermission() || !uriPermission.isWritePermission()) {
                context.getContentResolver().releasePersistableUriPermission(uriPermission.getUri(), 3);
                continue;
            }
            FileBrowserSAFEntry directory = FileBrowserSAFEntry.fromTreeUri(context, uriPermission.getUri());
            if (directory != null && directory.exists() && directory.isDirectory()) {
                stringBuilder.append(directory.getName()).append("<>").append(directory.getUri().toString()).append("<>");
                ++count;
                continue;
            }
            context.getContentResolver().releasePersistableUriPermission(uriPermission.getUri(), 3);
        }
        stringBuilder.append(count);
        return stringBuilder.toString();
    }

    @TargetApi(value=29)
    public static String OpenSAFFolder(Context context, String rawUri) {
        FileBrowserSAFEntry directory = new FileBrowserSAFEntry(context, Uri.parse((String)rawUri));
        ArrayList<FileBrowserSAFEntry> entries = directory.listFiles();
        stringBuilder.setLength(0);
        stringBuilder.append(entries.size()).append("<>");
        for (int i = 0; i < entries.size(); ++i) {
            FileBrowserSAFEntry entry = entries.get(i);
            stringBuilder.append(entry.isDirectory() ? "d" : "f").append(entry.getName()).append("<>").append(entry.getUri().toString()).append("<>");
        }
        return stringBuilder.toString();
    }

    @TargetApi(value=29)
    public static String CreateSAFEntry(Context context, String folderRawUri, boolean isFolder, String name) {
        String mimeType;
        FileBrowserSAFEntry directory = new FileBrowserSAFEntry(context, Uri.parse((String)folderRawUri));
        if (isFolder) {
            return directory.createDirectory(name).getUri().toString();
        }
        int extensionSeparator = name.lastIndexOf(46);
        String extension = extensionSeparator >= 0 ? name.substring(extensionSeparator + 1) : "";
        String string = mimeType = extension.length() > 0 ? MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension.toLowerCase(Locale.ENGLISH)) : null;
        if (mimeType == null || mimeType.length() == 0) {
            mimeType = "application/octet-stream";
        }
        return directory.createFile(mimeType, name).getUri().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=29)
    public static void WriteToSAFEntry(Context context, String rawUri, String sourceFile, boolean appendMode) {
        try (FileInputStream in = new FileInputStream(new File(sourceFile));
             OutputStream out = context.getContentResolver().openOutputStream(Uri.parse((String)rawUri), appendMode ? "wa" : "rwt");){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=29)
    public static void ReadFromSAFEntry(Context context, String rawUri, String destinationFile) {
        try {
            InputStream input = context.getContentResolver().openInputStream(Uri.parse((String)rawUri));
            if (input == null) {
                return;
            }
            OutputStream output = null;
            try {
                int len;
                output = new FileOutputStream(new File(destinationFile), false);
                byte[] buf = new byte[4096];
                while ((len = input.read(buf)) > 0) {
                    output.write(buf, 0, len);
                }
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                finally {
                    input.close();
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
        }
    }

    @TargetApi(value=29)
    public static boolean SAFEntryExists(Context context, String rawUri) {
        return new FileBrowserSAFEntry(context, Uri.parse((String)rawUri)).exists();
    }

    @TargetApi(value=29)
    public static boolean SAFEntryDirectory(Context context, String rawUri) {
        return new FileBrowserSAFEntry(context, Uri.parse((String)rawUri)).isDirectory();
    }

    @TargetApi(value=29)
    public static String SAFEntryName(Context context, String rawUri) {
        return new FileBrowserSAFEntry(context, Uri.parse((String)rawUri)).getName();
    }

    @TargetApi(value=29)
    public static long SAFEntrySize(Context context, String rawUri) {
        return new FileBrowserSAFEntry(context, Uri.parse((String)rawUri)).length();
    }

    @TargetApi(value=29)
    public static long SAFEntryLastModified(Context context, String rawUri) {
        return new FileBrowserSAFEntry(context, Uri.parse((String)rawUri)).lastModified();
    }

    @TargetApi(value=29)
    public static String RenameSAFEntry(Context context, String rawUri, String newName) {
        return new FileBrowserSAFEntry(context, Uri.parse((String)rawUri)).renameTo(newName);
    }

    @TargetApi(value=29)
    public static boolean DeleteSAFEntry(Context context, String rawUri) {
        return new FileBrowserSAFEntry(context, Uri.parse((String)rawUri)).delete();
    }

    @TargetApi(value=29)
    private static class UriPermissionSorter
    implements Comparator<UriPermission> {
        private UriPermissionSorter() {
        }

        @Override
        public int compare(UriPermission a, UriPermission b) {
            long difference = b.getPersistedTime() - a.getPersistedTime();
            if (difference < 0L) {
                return -1;
            }
            if (difference > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

