#include <DHT.h>

#define DHT_PIN A3
#define DHT_TYPE DHT11   // 或 DHT22

// 初始化DHT传感器
DHT dht(DHT_PIN, DHT_TYPE);

void setup() {
  // 用9600 bps的波特率启动串口:
  Serial.begin(9600);     //设置与电脑端一致的波特率
  dht.begin();        // 启动DHT传感器
  while (!Serial) {
    ;  //啥也不做，就等待USB串口连接成功
  }

  // 设置2号到13号引脚为输入模式
  for (int pin = 2; pin <= 13; pin++) {
    pinMode(pin, INPUT);
  }
}

//循环执行
void loop() {
  // 读取A0~A5端口的模拟值，得到形如“F:256,220,128,0,128,250”的字符串
  String combinedStr = "F:";    //用于存储所有模拟输入端口数值的字符串  
  //读取温湿度数据
  float temperature = dht.readTemperature(); //读取温度
  float humidity = dht.readHumidity();    //读取湿度
  //拼接字符串
  combinedStr += String(temperature);
  combinedStr += ",";
  combinedStr += String(humidity);
  combinedStr += "#";      //加个#标记结束，最终得到端口状态的混合字符串，得到形如“F:256,220#”的字符串

  Serial.println(combinedStr);  // 通过串口发送连接后的字符串
  delay(10);     //等待10毫秒后重新开始继续循环执行
}