void setup() {
  // 用9600 bps的波特率启动串口:
  Serial.begin(9600);     //设置与电脑端一致的波特率
  while (!Serial) {
    ;  //啥也不做，就等待USB串口连接成功
  }

  // 设置2号到13号引脚为输入模式
  for (int pin = 2; pin <= 13; pin++) {
    pinMode(pin, INPUT);
  }
}

//循环执行
void loop() {
  // 读取A0~A5端口的模拟值，得到形如“I:256,220,128,0,128,250”的字符串
  String analogValues = "I:";    //用于存储所有模拟输入端口数值的字符串  
  for (int pin = A0; pin <= A5; pin++) {      // 遍历所有模拟输入端口    
    int sensorValue = analogRead(pin);     // 读取模拟端口的值    
    analogValues += String(sensorValue);    // 将数值转换为字符串，并添加到analogValues字符串中
    if (pin < A5) {
      analogValues += ",";     // 为了格式的可读性，可以在每个数值之间添加逗号分隔符
    }
  }

  // 读取数字端口D2~D13继续连接数字端口的字符串
  String combinedStr = analogValues + "|B:";
  for (int pin = 2; pin < 14; pin++) {      
    if (digitalRead(pin) == HIGH) {
      combinedStr+='1';     // 读取引脚状态，如果为高电平则在相应的位上加1
    }
    else{
      combinedStr+='0';     // 读取引脚状态，如果为低电平则在相应的位上加0
    }
  }
  combinedStr += "#";      //加个#标记结束，最终得到端口状态的混合字符串，得到形如“I:256,220,128,0,128,250|B:100000110000#”的字符串

  Serial.println(combinedStr);  // 通过串口发送连接后的字符串
  delay(10);     //等待10毫秒后重新开始继续循环执行
}